/*
 * Decompiled with CFR 0.152.
 */
package openmods.clicky;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openmods.clicky.ClicketyClack;
import openmods.clicky.IKeyFilter;
import openmods.clicky.IconContainer;
import openmods.clicky.IndicatorPosition;
import openmods.clicky.RenderUtils;
import openmods.clicky.indicators.KeyIcon;
import openmods.clicky.indicators.SingleKeyIcon;
import openmods.clicky.indicators.WideKeyIcon;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class KeyboardIndicators {
    private final IKeyFilter keyFilter;
    private final IndicatorPosition position;
    private final int scale;
    private final int fadeTime;
    private final int blinkTime;
    private final IconContainer.IconHolder keyLeft;
    private final IconContainer.IconHolder keyMiddle;
    private final IconContainer.IconHolder keyRight;
    private final IconContainer.IconHolder keySingle;
    private final Map<Integer, KeyIcon> activeIcons = Maps.newHashMap();
    private final List<KeyIcon> icons = Lists.newLinkedList();
    private boolean visible = true;
    private int unstuckCounter;
    private static final Map<Integer, String> CUSTOM_NAMES;
    private static final Map<Integer, Integer> EXTRA_SIZE;
    private static final String GRAY = "\u00a77";

    public KeyboardIndicators(IconContainer icons, IndicatorPosition position, IKeyFilter keyFilter, int scale, int decayTime, int blinkTime) {
        this.position = position;
        this.keyFilter = keyFilter;
        this.scale = scale;
        this.fadeTime = decayTime;
        this.blinkTime = blinkTime;
        this.keyLeft = icons.getHolder(ClicketyClack.location("key_left"));
        this.keyMiddle = icons.getHolder(ClicketyClack.location("key_middle"));
        this.keyRight = icons.getHolder(ClicketyClack.location("key_right"));
        this.keySingle = icons.getHolder(ClicketyClack.location("key_single"));
    }

    private KeyIcon createIcon(String name, int key) {
        Integer size = EXTRA_SIZE.get(key);
        if (size != null) {
            if (size == 2) {
                return new WideKeyIcon(name, RenderUtils.getFontRenderer(), this.fadeTime, this.blinkTime, this.keyLeft, this.keyRight);
            }
            if (size > 2) {
                IconContainer.IconHolder[] result = new IconContainer.IconHolder[size.intValue()];
                result[0] = this.keyLeft;
                for (int i = 1; i < size - 1; ++i) {
                    result[i] = this.keyMiddle;
                }
                result[size.intValue() - 1] = this.keyRight;
                return new WideKeyIcon(name, RenderUtils.getFontRenderer(), this.fadeTime, this.blinkTime, result);
            }
        }
        return new SingleKeyIcon(this.keySingle, name, RenderUtils.getFontRenderer(), this.fadeTime, this.blinkTime);
    }

    public void keyEvent() {
        int key = Keyboard.getEventKey();
        boolean isDown = Keyboard.getEventKeyState();
        if (isDown && !this.keyFilter.isKeyFiltered(key)) {
            KeyIcon icon;
            String name = CUSTOM_NAMES.get(key);
            if (name == null) {
                name = Keyboard.getKeyName((int)key);
            }
            if ((icon = this.activeIcons.get(key)) != null) {
                icon.blink();
            } else {
                icon = this.createIcon(name, key);
                icon.resetDecay();
                this.activeIcons.put(key, icon);
                this.icons.add(icon);
            }
        } else {
            KeyIcon icon = this.activeIcons.remove(key);
            if (icon != null) {
                icon.startDecay();
            }
        }
    }

    public void toggle() {
        boolean bl = this.visible = !this.visible;
        if (!this.visible) {
            this.activeIcons.clear();
            this.icons.clear();
        }
    }

    public void tick() {
        Iterator<KeyIcon> icons = this.icons.iterator();
        if (this.unstuckCounter-- < 0) {
            this.unstuck();
            this.unstuckCounter = 20;
        }
        while (icons.hasNext()) {
            KeyIcon icon = icons.next();
            icon.tick();
            if (!icon.hasDecayed()) continue;
            icons.remove();
        }
    }

    private void unstuck() {
        Iterator<Map.Entry<Integer, KeyIcon>> it = this.activeIcons.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, KeyIcon> e = it.next();
            if (Keyboard.isKeyDown((int)e.getKey())) continue;
            e.getValue().startDecay();
            it.remove();
        }
    }

    public void render(float renderTick) {
        if (!this.visible) {
            return;
        }
        RenderUtils.bindDefaultItemsTexture();
        this.position.update();
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.position.x(), (double)this.position.y(), (double)0.0);
        GL11.glScaled((double)this.scale, (double)this.scale, (double)1.0);
        for (KeyIcon icon : this.icons) {
            icon.render(renderTick);
            GL11.glTranslated((double)icon.getWidth(), (double)0.0, (double)0.0);
        }
        GL11.glPopMatrix();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)57, (Object)"\u2423");
        builder.put((Object)200, (Object)"\u2191");
        builder.put((Object)208, (Object)"\u2193");
        builder.put((Object)203, (Object)"\u2190");
        builder.put((Object)205, (Object)"\u2192");
        builder.put((Object)1, (Object)"ESC");
        builder.put((Object)12, (Object)"-");
        builder.put((Object)13, (Object)"=");
        builder.put((Object)15, (Object)"\u21b9");
        builder.put((Object)26, (Object)"[");
        builder.put((Object)27, (Object)"]");
        builder.put((Object)28, (Object)"\u23ce");
        builder.put((Object)39, (Object)";");
        builder.put((Object)40, (Object)"'");
        builder.put((Object)41, (Object)"~");
        builder.put((Object)43, (Object)"\\");
        builder.put((Object)51, (Object)",");
        builder.put((Object)52, (Object)".");
        builder.put((Object)53, (Object)"/");
        builder.put((Object)55, (Object)"*");
        builder.put((Object)70, (Object)"SCROLL LOCK");
        builder.put((Object)58, (Object)"CAPS LOCK");
        builder.put((Object)69, (Object)"NUM LOCK");
        builder.put((Object)14, (Object)"\u232b");
        builder.put((Object)82, (Object)"\u00a770");
        builder.put((Object)79, (Object)"\u00a771");
        builder.put((Object)80, (Object)"\u00a772");
        builder.put((Object)81, (Object)"\u00a773");
        builder.put((Object)75, (Object)"\u00a774");
        builder.put((Object)76, (Object)"\u00a775");
        builder.put((Object)77, (Object)"\u00a776");
        builder.put((Object)71, (Object)"\u00a777");
        builder.put((Object)72, (Object)"\u00a778");
        builder.put((Object)73, (Object)"\u00a779");
        builder.put((Object)74, (Object)"\u00a77-");
        builder.put((Object)78, (Object)"\u00a77+");
        builder.put((Object)83, (Object)"\u00a77.");
        builder.put((Object)181, (Object)"\u00a77/");
        builder.put((Object)156, (Object)"\u23ce");
        builder.put((Object)183, (Object)"\u2603");
        builder.put((Object)0, (Object)"\u2623");
        builder.put((Object)221, (Object)"\u25a4");
        builder.put((Object)196, (Object)"\u2318");
        builder.put((Object)219, (Object)"\u2756");
        builder.put((Object)197, (Object)"PAUSE");
        builder.put((Object)29, (Object)"CTRL");
        builder.put((Object)157, (Object)"\u00a77CTRL");
        builder.put((Object)42, (Object)"\u21e7");
        builder.put((Object)54, (Object)"\u00a77\u21e7");
        builder.put((Object)56, (Object)"ALT");
        builder.put((Object)184, (Object)"\u00a77ALT");
        builder.put((Object)201, (Object)"PGUP");
        builder.put((Object)209, (Object)"PGDN");
        builder.put((Object)199, (Object)"HOME");
        builder.put((Object)207, (Object)"END");
        builder.put((Object)210, (Object)"INS");
        builder.put((Object)211, (Object)"DEL");
        CUSTOM_NAMES = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)1, (Object)2);
        builder.put((Object)70, (Object)5);
        builder.put((Object)58, (Object)4);
        builder.put((Object)69, (Object)4);
        builder.put((Object)197, (Object)2);
        builder.put((Object)29, (Object)2);
        builder.put((Object)157, (Object)2);
        builder.put((Object)56, (Object)2);
        builder.put((Object)184, (Object)2);
        builder.put((Object)201, (Object)2);
        builder.put((Object)209, (Object)2);
        builder.put((Object)199, (Object)2);
        builder.put((Object)207, (Object)2);
        builder.put((Object)68, (Object)2);
        builder.put((Object)87, (Object)2);
        builder.put((Object)88, (Object)2);
        builder.put((Object)210, (Object)2);
        builder.put((Object)211, (Object)2);
        builder.put((Object)42, (Object)2);
        builder.put((Object)54, (Object)2);
        builder.put((Object)15, (Object)2);
        EXTRA_SIZE = builder.build();
    }
}

