/*
 * Decompiled with CFR 0.152.
 */
package openmods.clicky;

import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import openmods.clicky.IconContainer;
import openmods.clicky.IndicatorPosition;
import openmods.clicky.KeyboardIndicators;
import openmods.clicky.MouseIndicators;
import openmods.clicky.config.ConfigValues;
import openmods.clicky.config.IndicatorConfig;
import openmods.clicky.config.KeyFilterConfig;
import openmods.clicky.config.KeyboardConfig;
import openmods.clicky.config.MouseConfig;
import org.lwjgl.opengl.GL11;

public class OverlayRenderHandler {
    private final IconContainer icons = new IconContainer();
    private MouseIndicators mouseIndicators;
    private KeyboardIndicators keyboardIndicators;

    public OverlayRenderHandler(ConfigValues config) {
        this.init(config);
    }

    private static IndicatorPosition createPosition(Minecraft minecraft, IndicatorConfig config) {
        return new IndicatorPosition(minecraft, config.dx, config.dy, config.vertical, config.horizontal);
    }

    public void init(ConfigValues values) {
        Minecraft mc = Minecraft.func_71410_x();
        MouseConfig mouse = values.mouse;
        this.mouseIndicators = mouse.visible ? new MouseIndicators(this.icons, OverlayRenderHandler.createPosition(mc, mouse), mouse.size, mouse.fadeTime, mouse.wheelEventDuration, mouse.wheelThreshold) : null;
        KeyboardConfig keyboard = values.keyboard;
        KeyFilterConfig filter = values.keyFilter;
        this.keyboardIndicators = keyboard.visible ? new KeyboardIndicators(this.icons, OverlayRenderHandler.createPosition(mc, keyboard), filter, keyboard.size, keyboard.fadeTime, keyboard.blinkTime) : null;
    }

    @SubscribeEvent
    public void mouseEvent(InputEvent.MouseInputEvent evt) {
        if (this.mouseIndicators != null) {
            this.mouseIndicators.mouseEvent();
        }
    }

    @SubscribeEvent
    public void mouseEvent(GuiScreenEvent.MouseInputEvent.Pre evt) {
        if (this.mouseIndicators != null) {
            this.mouseIndicators.mouseEvent();
        }
    }

    @SubscribeEvent
    public void keyEvent(InputEvent.KeyInputEvent evt) {
        if (this.keyboardIndicators != null) {
            this.keyboardIndicators.keyEvent();
        }
    }

    @SubscribeEvent
    public void keyEvent(GuiScreenEvent.KeyboardInputEvent.Pre evt) {
        if (this.keyboardIndicators != null) {
            this.keyboardIndicators.keyEvent();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent evt) {
        if (this.mouseIndicators != null) {
            this.mouseIndicators.tick();
        }
        if (this.keyboardIndicators != null) {
            this.keyboardIndicators.tick();
        }
    }

    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre evt) {
        this.icons.registerIcons(evt.map);
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.mouseIndicators != null) {
                this.mouseIndicators.render(evt.renderTickTime);
            }
            if (this.keyboardIndicators != null) {
                this.keyboardIndicators.render(evt.renderTickTime);
            }
            GL11.glDisable((int)3042);
        }
    }

    public void toggleMouse() {
        if (this.mouseIndicators != null) {
            this.mouseIndicators.toggle();
        }
    }

    public void toggleKeyboard() {
        if (this.keyboardIndicators != null) {
            this.keyboardIndicators.toggle();
        }
    }
}

