/*
 * Decompiled with CFR 0.152.
 */
package openmods.clicky.config;

import com.google.common.collect.Lists;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.IConfigElement;
import openmods.clicky.IKeyFilter;
import org.lwjgl.input.Keyboard;

public class KeyFilterConfig
implements IKeyFilter {
    public static final String KEY_KEYS = "keys";
    private final TIntHashSet filteredKeys;

    private static Property getProperty(Configuration config) {
        return config.get("key_filter", KEY_KEYS, new int[0], "List of key codes to be ignored (see http://minecraft.gamepedia.com/Key_codes for list)");
    }

    public static IConfigElement createConfigurationCategory(Configuration config) {
        Property property = KeyFilterConfig.getProperty(config);
        TIntHashSet values = new TIntHashSet(property.getIntList());
        ArrayList filterList = Lists.newArrayList();
        for (int keyCode = 0; keyCode < 256; ++keyCode) {
            String keyName = Keyboard.getKeyName((int)keyCode);
            if (keyName == null) continue;
            filterList.add(new FlagArrayElement(property, (TIntSet)values, keyCode, keyName));
        }
        ConfigCategory category = config.getCategory("key_filter");
        return new DummyConfigElement.DummyCategoryElement(category.getName(), category.getLanguagekey(), (List)filterList);
    }

    public KeyFilterConfig(Configuration config) {
        Property property = KeyFilterConfig.getProperty(config);
        this.filteredKeys = new TIntHashSet(property.getIntList());
    }

    @Override
    public boolean isKeyFiltered(int keyCode) {
        return this.filteredKeys.contains(keyCode);
    }

    private static class FlagArrayElement
    extends DummyConfigElement {
        private final Property property;
        private final int keyCode;
        private final TIntSet config;

        public FlagArrayElement(Property property, TIntSet config, int keyCode, String keyName) {
            super(keyName, (Object)config.contains(keyCode), ConfigGuiType.BOOLEAN, "");
            this.property = property;
            this.config = config;
            this.keyCode = keyCode;
        }

        public void set(Object value) {
            super.set(value);
            if (value == Boolean.TRUE) {
                this.config.add(this.keyCode);
            } else {
                this.config.remove(this.keyCode);
            }
            int[] filter = this.config.toArray();
            Arrays.sort(filter);
            this.property.set(filter);
        }
    }
}

