/*
 * Decompiled with CFR 0.152.
 */
package openmods.clicky.indicators;

import net.minecraft.client.gui.FontRenderer;
import openmods.clicky.indicators.DecayingIcon;
import openmods.clicky.indicators.Timer;
import org.lwjgl.opengl.GL11;

public abstract class KeyIcon
extends DecayingIcon {
    private static final float TEXT_SCALE = 0.0625f;
    private static final float TEXT_DELTA = 0.28125f;
    private final String contents;
    private final FontRenderer fontRenderer;
    private final float textWidth;
    private final Timer blinkTimer;

    public KeyIcon(String contents, FontRenderer fontRenderer, int decayTime, int blinkTime) {
        super(decayTime);
        this.contents = contents;
        this.fontRenderer = fontRenderer;
        this.textWidth = (float)(fontRenderer.func_78256_a(contents) - 1) / 16.0f;
        this.blinkTimer = new Timer(blinkTime);
    }

    public abstract float getWidth();

    @Override
    protected final void renderIcon(float partialTick, float alpha) {
        float blink = this.getBlinkProgress(partialTick);
        this.renderIcon(partialTick, alpha, blink);
    }

    protected abstract void renderIcon(float var1, float var2, float var3);

    protected void renderText(float blink, float alpha) {
        float middle = (this.getWidth() - this.textWidth) / 2.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)middle, (float)0.28125f, (float)100.0f);
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0f);
        int redByte = (int)(blink * 255.0f) & 0xFF;
        int alphaByte = (int)(alpha * 255.0f) & 0xFF;
        int color = alphaByte << 24 | redByte << 16;
        this.fontRenderer.func_78276_b(this.contents, 0, 0, color);
        GL11.glPopMatrix();
    }

    public void blink() {
        this.blinkTimer.resetAndStart();
    }

    @Override
    public void tick() {
        super.tick();
        this.blinkTimer.tick();
    }

    private float getBlinkProgress(float partialTick) {
        return this.blinkTimer.isTicking() && !this.blinkTimer.isFinished() ? this.blinkTimer.getProgress(partialTick) : 0.0f;
    }
}

