/*
 * Decompiled with CFR 0.152.
 */
package openmods.clicky.indicators;

class Timer {
    private final int duration;
    private int counter;
    private boolean isTicking;

    public Timer(int duration) {
        this.duration = duration;
    }

    public void reset() {
        this.isTicking = false;
        this.counter = this.duration;
    }

    public void start() {
        this.isTicking = true;
    }

    public void resetAndStart() {
        this.isTicking = true;
        this.counter = this.duration;
    }

    public void tick() {
        if (this.isTicking) {
            --this.counter;
        }
    }

    public boolean isFinished() {
        return this.isTicking && this.counter <= 0;
    }

    public boolean isTicking() {
        return this.isTicking;
    }

    public float getProgress(float partialTick) {
        return Math.min(1.0f, ((float)this.counter + partialTick) / (float)this.duration);
    }
}

