/*
 * Decompiled with CFR 0.152.
 */
package openmods.clicky;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class IconContainer {
    private final Map<ResourceLocation, IconHolder> icons = Maps.newHashMap();

    public IconHolder getHolder(ResourceLocation iconName) {
        IconHolder holder = this.icons.get(iconName);
        if (holder == null) {
            holder = new IconHolder(iconName);
            this.icons.put(iconName, holder);
        }
        return holder;
    }

    public void registerIcons(TextureMap textureMap) {
        for (IconHolder layer : this.icons.values()) {
            layer.register(textureMap);
        }
    }

    public static class IconHolder {
        private final ResourceLocation iconLocation;
        private TextureAtlasSprite icon;

        private IconHolder(ResourceLocation iconLocation) {
            this.iconLocation = iconLocation;
        }

        private void register(TextureMap registry) {
            this.icon = registry.func_174942_a(this.iconLocation);
        }

        public TextureAtlasSprite get() {
            return this.icon;
        }
    }
}

