/*
 * Decompiled with CFR 0.152.
 */
package openmods.clicky;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import openmods.clicky.ClicketyClack;
import openmods.clicky.IconContainer;
import openmods.clicky.IndicatorPosition;
import openmods.clicky.RenderUtils;
import openmods.clicky.indicators.EventIcon;
import openmods.clicky.indicators.MouseButtonEvent;
import openmods.clicky.indicators.MouseWheelEvent;
import openmods.clicky.indicators.Renderable;
import openmods.clicky.indicators.StaticIcon;
import openmods.clicky.indicators.Ticker;

public class MouseIndicators {
    private final IndicatorPosition position;
    private final int scale;
    private final StaticIcon background;
    private final List<EventIcon> indicators;
    private boolean visible = true;

    public MouseIndicators(IconContainer icons, IndicatorPosition position, int scale, int decayTime, int wheelDuration, int wheelThreshold) {
        this.position = position;
        this.scale = scale;
        ImmutableList.Builder indicators = ImmutableList.builder();
        this.background = new StaticIcon(icons.getHolder(ClicketyClack.location("mouse_background")));
        indicators.add((Object)new MouseWheelEvent(icons.getHolder(ClicketyClack.location("mouse_up")), decayTime, wheelThreshold, wheelDuration){

            @Override
            protected boolean shouldTrigger(int delta, int threshold) {
                return delta > threshold;
            }
        });
        indicators.add((Object)new MouseWheelEvent(icons.getHolder(ClicketyClack.location("mouse_down")), decayTime, wheelThreshold, wheelDuration){

            @Override
            protected boolean shouldTrigger(int delta, int threshold) {
                return delta < -threshold;
            }
        });
        indicators.add((Object)new MouseButtonEvent(icons.getHolder(ClicketyClack.location("mouse_left")), decayTime, 0));
        indicators.add((Object)new MouseButtonEvent(icons.getHolder(ClicketyClack.location("mouse_right")), decayTime, 1));
        indicators.add((Object)new MouseButtonEvent(icons.getHolder(ClicketyClack.location("mouse_middle")), decayTime, 2));
        this.indicators = indicators.build();
    }

    public void toggle() {
        this.visible = !this.visible;
    }

    public void tick() {
        for (Ticker ticker : this.indicators) {
            ticker.tick();
        }
    }

    public void mouseEvent() {
        for (EventIcon handler : this.indicators) {
            handler.handleInput();
        }
    }

    public void render(float partialTick) {
        if (!this.visible) {
            return;
        }
        RenderUtils.bindDefaultItemsTexture();
        this.position.update();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.position.x(), (float)this.position.y(), (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        this.background.render(partialTick);
        for (Renderable renderable : this.indicators) {
            renderable.render(partialTick);
        }
        GlStateManager.func_179121_F();
    }
}

