/*
 * Decompiled with CFR 0.152.
 */
package openmods.clicky;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import openmods.clicky.IconContainer;
import openmods.clicky.IndicatorPosition;
import openmods.clicky.KeyboardIndicators;
import openmods.clicky.MouseIndicators;
import openmods.clicky.config.ConfigValues;
import openmods.clicky.config.IndicatorConfig;
import openmods.clicky.config.KeyFilterConfig;
import openmods.clicky.config.KeyboardConfig;
import openmods.clicky.config.MouseConfig;

public class OverlayRenderHandler {
    private final IconContainer icons = new IconContainer();
    private MouseIndicators mouseIndicators;
    private KeyboardIndicators keyboardIndicators;

    public OverlayRenderHandler(ConfigValues config) {
        this.init(config);
    }

    private static IndicatorPosition createPosition(Minecraft minecraft, IndicatorConfig config) {
        return new IndicatorPosition(minecraft, config.dx, config.dy, config.vertical, config.horizontal);
    }

    public void init(ConfigValues values) {
        Minecraft mc = Minecraft.func_71410_x();
        MouseConfig mouse = values.mouse;
        this.mouseIndicators = mouse.visible ? new MouseIndicators(this.icons, OverlayRenderHandler.createPosition(mc, mouse), mouse.size, mouse.fadeTime, mouse.wheelEventDuration, mouse.wheelThreshold) : null;
        KeyboardConfig keyboard = values.keyboard;
        KeyFilterConfig filter = values.keyFilter;
        this.keyboardIndicators = keyboard.visible ? new KeyboardIndicators(this.icons, OverlayRenderHandler.createPosition(mc, keyboard), filter, keyboard.size, keyboard.fadeTime, keyboard.blinkTime) : null;
    }

    @SubscribeEvent
    public void mouseEvent(InputEvent.MouseInputEvent evt) {
        if (this.mouseIndicators != null) {
            this.mouseIndicators.mouseEvent();
        }
    }

    @SubscribeEvent
    public void mouseEvent(GuiScreenEvent.MouseInputEvent.Pre evt) {
        if (this.mouseIndicators != null) {
            this.mouseIndicators.mouseEvent();
        }
    }

    @SubscribeEvent
    public void keyEvent(InputEvent.KeyInputEvent evt) {
        if (this.keyboardIndicators != null) {
            this.keyboardIndicators.keyEvent();
        }
    }

    @SubscribeEvent
    public void keyEvent(GuiScreenEvent.KeyboardInputEvent.Pre evt) {
        if (this.keyboardIndicators != null) {
            this.keyboardIndicators.keyEvent();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent evt) {
        if (this.mouseIndicators != null) {
            this.mouseIndicators.tick();
        }
        if (this.keyboardIndicators != null) {
            this.keyboardIndicators.tick();
        }
    }

    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre evt) {
        this.icons.registerIcons(evt.getMap());
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            if (this.mouseIndicators != null) {
                this.mouseIndicators.render(evt.renderTickTime);
            }
            if (this.keyboardIndicators != null) {
                this.keyboardIndicators.render(evt.renderTickTime);
            }
        }
    }

    public void toggleMouse() {
        if (this.mouseIndicators != null) {
            this.mouseIndicators.toggle();
        }
    }

    public void toggleKeyboard() {
        if (this.keyboardIndicators != null) {
            this.keyboardIndicators.toggle();
        }
    }
}

