/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr;

import net.sourceforge.jaad.aac.sbr.Calculation;
import net.sourceforge.jaad.aac.sbr.ChannelData;
import net.sourceforge.jaad.aac.sbr.SBR;
import net.sourceforge.jaad.aac.sbr.SBRConstants;

class HFGeneration
implements SBRConstants {
    private static final int[] GOAL_SB_TABLE = new int[]{21, 23, 32, 43, 46, 64, 85, 93, 128, 0, 0, 0};
    private static final float[][] BW_VALUES = new float[][]{{0.0f, 0.6f}, {0.75f, 0.6f}, {0.9f, 0.9f}, {0.98f, 0.98f}};
    private static final float BW_MIN = 0.015625f;
    private static final float BW_MAX = 0.99609375f;
    private static final float[] CHIRP_COEFS = new float[]{0.75f, 0.25f, 0.90625f, 0.09375f};
    private static final float AC_REL = 0.999999f;
    private final SBR sbr;
    private final float[][] alpha0;
    private final float[][] alpha1;
    private final float[] a0;
    private final float[] a1;
    private final ACCoefs ac;

    HFGeneration(SBR sbr) {
        this.sbr = sbr;
        this.alpha0 = new float[64][2];
        this.alpha1 = new float[64][2];
        this.a0 = new float[2];
        this.a1 = new float[2];
        this.ac = new ACCoefs();
    }

    void process(float[][][] Xlow, float[][][] Xhigh, int ch, ChannelData cd) {
        int offset = 2;
        int first = cd.t_E[0];
        int last = cd.t_E[cd.L_E];
        this.calculateChirpFactors(cd);
        if (ch == 0 && this.sbr.reset) {
            this.constructPatches();
        }
        for (int i = 0; i < this.sbr.patches; ++i) {
            for (int j = 0; j < this.sbr.patchNoSubbands[i]; ++j) {
                int l;
                int k = this.sbr.kx + j;
                for (l = 0; l < i; ++l) {
                    k += this.sbr.patchNoSubbands[l];
                }
                int off = this.sbr.patchStartSubband[i] + j;
                int g = this.sbr.tableMapKToG[k];
                float bw = cd.bwArray[g];
                float bw2 = bw * bw;
                if (bw2 > 0.0f) {
                    this.calculatePredictionCoef(Xlow, off);
                    this.a0[0] = this.alpha0[off][0] * bw;
                    this.a1[0] = this.alpha1[off][0] * bw2;
                    this.a0[1] = this.alpha0[off][1] * bw;
                    this.a1[1] = this.alpha1[off][1] * bw2;
                    float temp2_r = Xlow[first - 2 + 2][off][0];
                    float temp3_r = Xlow[first - 1 + 2][off][0];
                    float temp2_i = Xlow[first - 2 + 2][off][1];
                    float temp3_i = Xlow[first - 1 + 2][off][1];
                    for (l = first; l < last; ++l) {
                        float temp1_r = temp2_r;
                        temp2_r = temp3_r;
                        temp3_r = Xlow[l + 2][off][0];
                        float temp1_i = temp2_i;
                        temp2_i = temp3_i;
                        temp3_i = Xlow[l + 2][off][1];
                        Xhigh[l + 2][k][0] = temp3_r + (this.a0[0] * temp2_r - this.a0[1] * temp2_i + this.a1[0] * temp1_r - this.a1[1] * temp1_i);
                        Xhigh[l + 2][k][1] = temp3_i + (this.a0[1] * temp2_r + this.a0[0] * temp2_i + this.a1[1] * temp1_r + this.a1[0] * temp1_i);
                    }
                    continue;
                }
                for (l = first; l < last; ++l) {
                    Xhigh[l + 2][k][0] = Xlow[l + 2][off][0];
                    Xhigh[l + 2][k][1] = Xlow[l + 2][off][1];
                }
            }
        }
        if (this.sbr.reset) {
            this.sbr.calculateLimiterFrequencyTable();
        }
    }

    private void calculateChirpFactors(ChannelData cd) {
        for (int i = 0; i < this.sbr.N_Q; ++i) {
            cd.bwArray[i] = this.getBW(cd.invfMode[i], cd.invfModePrev[i]);
            int off = cd.bwArray[i] < cd.bwArrayPrev[i] ? 0 : 2;
            cd.bwArray[i] = cd.bwArray[i] * CHIRP_COEFS[off] + cd.bwArrayPrev[i] * CHIRP_COEFS[off + 1];
            if (cd.bwArray[i] < 0.015625f) {
                cd.bwArray[i] = 0.0f;
            }
            if (cd.bwArray[i] >= 0.99609375f) {
                cd.bwArray[i] = 0.99609375f;
            }
            cd.bwArrayPrev[i] = cd.bwArray[i];
            cd.invfModePrev[i] = cd.invfMode[i];
        }
    }

    private float getBW(int invfMode, int invfModePrev) {
        int sec = invfMode == 0 ? (invfModePrev == 1 ? 1 : 0) : (invfMode == 1 ? (invfModePrev == 0 ? 1 : 0) : 0);
        return BW_VALUES[invfMode][sec];
    }

    private void constructPatches() {
        int sb;
        int k;
        int goalSb = GOAL_SB_TABLE[Calculation.getSampleRateIndex(this.sbr.sampleRate)];
        this.sbr.patches = 0;
        if (goalSb < this.sbr.kx + this.sbr.M) {
            int i = 0;
            k = 0;
            while (this.sbr.mft[i] < goalSb) {
                k = i + 1;
                ++i;
            }
        } else {
            k = this.sbr.N_master;
        }
        if (this.sbr.N_master == 0) {
            this.sbr.patchNoSubbands[0] = 0;
            this.sbr.patchStartSubband[0] = 0;
            return;
        }
        int msb = this.sbr.k0;
        int usb = this.sbr.kx;
        do {
            int odd;
            int j = k + 1;
            while ((sb = this.sbr.mft[--j]) > this.sbr.k0 - 1 + msb - (odd = (sb - 2 + this.sbr.k0) % 2)) {
            }
            this.sbr.patchNoSubbands[this.sbr.patches] = Math.max(sb - usb, 0);
            this.sbr.patchStartSubband[this.sbr.patches] = this.sbr.k0 - odd - this.sbr.patchNoSubbands[this.sbr.patches];
            if (this.sbr.patchNoSubbands[this.sbr.patches] > 0) {
                usb = sb;
                msb = sb;
                ++this.sbr.patches;
            } else {
                msb = this.sbr.kx;
            }
            if (this.sbr.mft[k] - sb >= 3) continue;
            k = this.sbr.N_master;
        } while (sb != this.sbr.kx + this.sbr.M);
        if (this.sbr.patchNoSubbands[this.sbr.patches - 1] < 3 && this.sbr.patches > 1) {
            --this.sbr.patches;
        }
        this.sbr.patches = Math.min(this.sbr.patches, 5);
    }

    private void calculatePredictionCoef(float[][][] Xlow, int k) {
        float tmp;
        this.calculateAutoCorrelation(Xlow, k, 38);
        if (this.ac.det == 0.0f) {
            this.alpha1[k][0] = 0.0f;
            this.alpha1[k][1] = 0.0f;
        } else {
            tmp = 1.0f / this.ac.det;
            this.alpha1[k][0] = (this.ac.r01[0] * this.ac.r12[0] - this.ac.r01[1] * this.ac.r12[1] - this.ac.r02[0] * this.ac.r11) * tmp;
            this.alpha1[k][1] = (this.ac.r01[1] * this.ac.r12[0] + this.ac.r01[0] * this.ac.r12[1] - this.ac.r02[1] * this.ac.r11) * tmp;
        }
        if (this.ac.r11 == 0.0f) {
            this.alpha0[k][0] = 0.0f;
            this.alpha0[k][1] = 0.0f;
        } else {
            tmp = 1.0f / this.ac.r11;
            this.alpha0[k][0] = -(this.ac.r01[0] + this.alpha1[k][0] * this.ac.r12[0] + this.alpha1[k][1] * this.ac.r12[1]) * tmp;
            this.alpha0[k][1] = -(this.ac.r01[1] + this.alpha1[k][1] * this.ac.r12[0] - this.alpha1[k][0] * this.ac.r12[1]) * tmp;
        }
        if (this.alpha0[k][0] * this.alpha0[k][0] + this.alpha0[k][1] * this.alpha0[k][1] >= 16.0f || this.alpha1[k][0] * this.alpha1[k][0] + this.alpha1[k][1] * this.alpha1[k][1] >= 16.0f) {
            this.alpha0[k][0] = 0.0f;
            this.alpha0[k][1] = 0.0f;
            this.alpha1[k][0] = 0.0f;
            this.alpha1[k][1] = 0.0f;
        }
    }

    private ACCoefs calculateAutoCorrelation(float[][][] buffer, int bd, int len) {
        int offset = 2;
        float temp2r = buffer[0][bd][0];
        float temp2i = buffer[0][bd][1];
        float temp3r = buffer[1][bd][0];
        float temp3i = buffer[1][bd][1];
        float[] temp4 = new float[]{temp2r, temp2i};
        float[] temp5 = new float[]{temp3r, temp3i};
        float[] r01 = new float[2];
        float[] r02 = new float[2];
        float r11 = 0.0f;
        float[] temp1 = new float[2];
        for (int i = 2; i < len + 2; ++i) {
            temp1[0] = temp2r;
            temp1[1] = temp2i;
            temp2r = temp3r;
            temp2i = temp3i;
            temp3r = buffer[i][bd][0];
            temp3i = buffer[i][bd][1];
            r01[0] = r01[0] + (temp3r * temp2r + temp3i * temp2i);
            r01[1] = r01[1] + (temp3i * temp2r - temp3r * temp2i);
            r02[0] = r02[0] + (temp3r * temp1[0] + temp3i * temp1[1]);
            r02[1] = r02[1] + (temp3i * temp1[0] - temp3r * temp1[1]);
            r11 += temp2r * temp2r + temp2i * temp2i;
        }
        this.ac.r12[0] = r01[0] - (temp3r * temp2r + temp3i * temp2i) + (temp5[0] * temp4[0] + temp5[1] * temp4[1]);
        this.ac.r12[1] = r01[1] - (temp3i * temp2r - temp3r * temp2i) + (temp5[1] * temp4[0] - temp5[0] * temp4[1]);
        this.ac.r22[0] = r11 - (temp2r * temp2r + temp2i * temp2i) + (temp4[0] * temp4[0] + temp4[1] * temp4[1]);
        this.ac.r01 = r01;
        this.ac.r02 = r02;
        this.ac.r11 = r11;
        this.ac.det = this.ac.r11 * this.ac.r22[0] - 0.999999f * (this.ac.r12[0] * this.ac.r12[0] + this.ac.r12[1] * this.ac.r12[1]);
        return this.ac;
    }

    private static class ACCoefs {
        float[] r01 = new float[2];
        float[] r02 = new float[2];
        float r11 = 0.0f;
        float[] r12 = new float[2];
        float[] r22 = new float[2];
        float det = 0.0f;

        private ACCoefs() {
        }
    }
}

