/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.syntax.BitStream;

class SBRHeader {
    private boolean decoded = false;
    private boolean reset;
    private boolean ampRes;
    private int startFrequency;
    private int startFrequencyPrev;
    private int stopFrequency;
    private int stopFrequencyPrev;
    private int xOverBand;
    private int xOverBandPrev;
    private int frequencyScale;
    private int frequencyScalePrev;
    private boolean alterScale;
    private boolean alterScalePrev;
    private int noiseBands;
    private int noiseBandsPrev;
    private int limiterBands;
    private int limiterGains;
    private boolean interpolFrequency;
    private boolean smoothingMode;

    SBRHeader() {
    }

    void decode(BitStream in) throws AACException {
        if (!this.decoded) {
            this.decoded = true;
        }
        this.startFrequencyPrev = this.startFrequency;
        this.stopFrequencyPrev = this.stopFrequency;
        this.frequencyScalePrev = this.frequencyScale;
        this.alterScalePrev = this.alterScale;
        this.xOverBandPrev = this.xOverBand;
        this.noiseBandsPrev = this.noiseBands;
        this.ampRes = in.readBool();
        this.startFrequency = in.readBits(4);
        this.stopFrequency = in.readBits(4);
        this.xOverBand = in.readBits(3);
        in.skipBits(2);
        boolean extraHeader1 = in.readBool();
        boolean extraHeader2 = in.readBool();
        if (extraHeader1) {
            this.frequencyScale = in.readBits(2);
            this.alterScale = in.readBool();
            this.noiseBands = in.readBits(2);
        } else {
            this.frequencyScale = 2;
            this.alterScale = true;
            this.noiseBands = 2;
        }
        if (extraHeader2) {
            this.limiterBands = in.readBits(2);
            this.limiterGains = in.readBits(2);
            this.interpolFrequency = in.readBool();
            this.smoothingMode = in.readBool();
        } else {
            this.limiterBands = 2;
            this.limiterGains = 2;
            this.interpolFrequency = true;
            this.smoothingMode = true;
        }
        this.reset = this.startFrequency != this.startFrequencyPrev || this.stopFrequency != this.stopFrequencyPrev || this.frequencyScale != this.frequencyScalePrev || this.alterScale != this.alterScalePrev || this.xOverBand != this.xOverBandPrev || this.noiseBands != this.noiseBandsPrev;
    }

    void newFrame() {
        this.reset = false;
    }

    public boolean isDecoded() {
        return this.decoded;
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean getAmpRes() {
        return this.ampRes;
    }

    public int getStartFrequency(boolean previous) {
        return previous ? this.startFrequencyPrev : this.startFrequency;
    }

    public int getStopFrequency(boolean previous) {
        return previous ? this.stopFrequencyPrev : this.stopFrequency;
    }

    public int getXOverBand(boolean previous) {
        return previous ? this.xOverBandPrev : this.xOverBand;
    }

    public int getFrequencyScale(boolean previous) {
        return previous ? this.frequencyScalePrev : this.frequencyScale;
    }

    public boolean isAlterScale(boolean previous) {
        return previous ? this.alterScalePrev : this.alterScale;
    }

    public int getNoiseBands(boolean previous) {
        return previous ? this.noiseBandsPrev : this.noiseBands;
    }

    public int getLimiterBands() {
        return this.limiterBands;
    }

    public int getLimiterGains() {
        return this.limiterGains;
    }

    public boolean interpolateFrequency() {
        return this.interpolFrequency;
    }

    public boolean isSmoothingMode() {
        return this.smoothingMode;
    }
}

