/*
 * Decompiled with CFR 0.152.
 */
package openmods.codecs.adapters;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFormat;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import openmods.codecs.Log;
import openmods.codecs.Utils;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;

public abstract class CodecAacBase
implements ICodec {
    protected boolean initialized;
    protected AudioFormat format;
    private Decoder decoder;
    private boolean streamClosed;
    private SampleBuffer buf;
    private DataInputStream in;
    private boolean reverseBytes;
    private boolean endianessConflict;
    private int sampleInBytes;

    public void reverseByteOrder(boolean b) {
        this.reverseBytes = b;
    }

    public boolean initialize(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            this.in = new DataInputStream(conn.getInputStream());
            this.initializeStream(url, this.in);
            this.decoder = new Decoder(this.getDecoderSpecificInfo());
            this.buf = new SampleBuffer();
            this.initialized = true;
            this.updateBuffer();
            this.format = new AudioFormat(this.buf.getSampleRate(), this.buf.getBitsPerSample(), this.buf.getChannels(), true, this.buf.isBigEndian());
            this.validateFormat(url);
            this.sampleInBytes = this.format.getSampleSizeInBits() / 8;
            this.endianessConflict = this.format.isBigEndian() && this.reverseBytes;
            return true;
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to initalize codec for url '%s'", url);
            return false;
        }
    }

    protected abstract void initializeStream(URL var1, DataInputStream var2) throws IOException;

    protected abstract byte[] getDecoderSpecificInfo();

    protected abstract void validateFormat(URL var1);

    protected abstract byte[] readNextFrame() throws IOException;

    protected abstract void cleanupSpecific();

    private static boolean formatChanged(AudioFormat af, SampleBuffer buf) {
        return af.getSampleRate() != (float)buf.getSampleRate() || af.getChannels() != buf.getChannels() || af.getSampleSizeInBits() != buf.getBitsPerSample() || af.isBigEndian() != buf.isBigEndian();
    }

    public boolean initialized() {
        return this.initialized;
    }

    public boolean endOfStream() {
        return this.streamClosed;
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    private void updateBuffer() throws IOException {
        byte[] b = this.readNextFrame();
        this.decoder.decodeFrame(b, this.buf);
    }

    private boolean appendBytes(ByteArrayOutputStream output) throws IOException {
        byte[] data = this.buf.getData();
        if (this.endianessConflict) {
            Utils.convertEndianness(data, this.sampleInBytes);
        }
        output.write(data);
        this.updateBuffer();
        if (CodecAacBase.formatChanged(this.format, this.buf)) {
            Log.warn("Stream format changed, aborting", new Object[0]);
            this.streamClosed = true;
            return false;
        }
        return true;
    }

    public SoundBuffer read() {
        if (!this.initialized || this.streamClosed) {
            return null;
        }
        int limit = SoundSystemConfig.getStreamingBufferSize();
        ByteArrayOutputStream output = new ByteArrayOutputStream(limit);
        try {
            while (this.appendBytes(output) && !this.streamClosed && output.size() < limit) {
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Error in stream decoding, aborting", new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.format);
    }

    public SoundBuffer readAll() {
        if (!this.initialized || this.streamClosed) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            while (this.appendBytes(output) && !this.streamClosed) {
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Error in stream decoding, aborting", new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.format);
    }

    public void cleanup() {
        this.streamClosed = true;
        this.initialized = false;
        this.cleanupSpecific();
        this.decoder = null;
        try {
            this.in.close();
        }
        catch (IOException e) {
            Log.warn(e, "Can't close stream", new Object[0]);
        }
    }
}

