/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;
import org.kc7bfi.jflac.ChannelData;
import org.kc7bfi.jflac.Constants;
import org.kc7bfi.jflac.FrameDecodeException;
import org.kc7bfi.jflac.FrameListener;
import org.kc7bfi.jflac.FrameListeners;
import org.kc7bfi.jflac.PCMProcessor;
import org.kc7bfi.jflac.PCMProcessors;
import org.kc7bfi.jflac.frame.BadHeaderException;
import org.kc7bfi.jflac.frame.ChannelConstant;
import org.kc7bfi.jflac.frame.ChannelFixed;
import org.kc7bfi.jflac.frame.ChannelLPC;
import org.kc7bfi.jflac.frame.ChannelVerbatim;
import org.kc7bfi.jflac.frame.Frame;
import org.kc7bfi.jflac.frame.Header;
import org.kc7bfi.jflac.io.BitInputStream;
import org.kc7bfi.jflac.io.RandomFileInputStream;
import org.kc7bfi.jflac.metadata.Application;
import org.kc7bfi.jflac.metadata.CueSheet;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.Padding;
import org.kc7bfi.jflac.metadata.Picture;
import org.kc7bfi.jflac.metadata.SeekPoint;
import org.kc7bfi.jflac.metadata.SeekTable;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.metadata.Unknown;
import org.kc7bfi.jflac.metadata.VorbisComment;
import org.kc7bfi.jflac.util.ByteData;
import org.kc7bfi.jflac.util.CRC16;

public class FLACDecoder {
    private static final int FRAME_FOOTER_CRC_LEN = 16;
    private static final byte[] ID3V2_TAG = new byte[]{73, 68, 51};
    private BitInputStream bitStream;
    private ChannelData[] channelData = new ChannelData[8];
    private int outputCapacity;
    private int outputChannels;
    private long samplesDecoded;
    private StreamInfo streamInfo;
    private Frame frame = new Frame();
    private byte[] headerWarmup = new byte[2];
    private int channels;
    private int channelAssignment;
    private int bitsPerSample;
    private int sampleRate;
    private int blockSize;
    private InputStream inputStream;
    private int metadataLength;
    private int badFrames;
    private boolean eof = false;
    private FrameListeners frameListeners = new FrameListeners();
    private PCMProcessors pcmProcessors = new PCMProcessors();
    private static final boolean __SEEK_DEBUG = false;
    static final boolean __DEBUG = false;

    public FLACDecoder(InputStream inputStream) {
        this.inputStream = inputStream;
        this.bitStream = new BitInputStream(inputStream);
        this.samplesDecoded = 0L;
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }

    public ChannelData[] getChannelData() {
        return this.channelData;
    }

    public BitInputStream getBitInputStream() {
        return this.bitStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void addFrameListener(FrameListener listener) {
        this.frameListeners.addFrameListener(listener);
    }

    public void removeFrameListener(FrameListener listener) {
        this.frameListeners.removeFrameListener(listener);
    }

    public void addPCMProcessor(PCMProcessor processor) {
        this.pcmProcessors.addPCMProcessor(processor);
    }

    public void removePCMProcessor(PCMProcessor processor) {
        this.pcmProcessors.removePCMProcessor(processor);
    }

    public long getMetadataLength() {
        return this.metadataLength;
    }

    private boolean callPCMProcessors(Frame frame) {
        ByteData bd = this.decodeFrame(frame, null);
        this.pcmProcessors.processPCM(bd);
        return !this.pcmProcessors.isCanceled();
    }

    public ByteData decodeFrame(Frame frame, ByteData pcmData) {
        block9: {
            block10: {
                block8: {
                    int byteSize = frame.header.blockSize * this.channels * ((this.streamInfo.getBitsPerSample() + 7) / 2);
                    if (pcmData == null || pcmData.getData().length < byteSize) {
                        pcmData = new ByteData(byteSize);
                    } else {
                        pcmData.setLen(0);
                    }
                    if (this.streamInfo.getBitsPerSample() != 8) break block8;
                    int i = 0;
                    while (i < frame.header.blockSize) {
                        int channel = 0;
                        while (channel < this.channels) {
                            pcmData.append((byte)(this.channelData[channel].getOutput()[i] + 128));
                            ++channel;
                        }
                        ++i;
                    }
                    break block9;
                }
                if (this.streamInfo.getBitsPerSample() != 16) break block10;
                int i = 0;
                while (i < frame.header.blockSize) {
                    int channel = 0;
                    while (channel < this.channels) {
                        short val = (short)this.channelData[channel].getOutput()[i];
                        pcmData.append((byte)(val & 0xFF));
                        pcmData.append((byte)(val >> 8 & 0xFF));
                        ++channel;
                    }
                    ++i;
                }
                break block9;
            }
            if (this.streamInfo.getBitsPerSample() != 24) break block9;
            int i = 0;
            while (i < frame.header.blockSize) {
                int channel = 0;
                while (channel < this.channels) {
                    int val = this.channelData[channel].getOutput()[i];
                    pcmData.append((byte)(val & 0xFF));
                    pcmData.append((byte)(val >> 8 & 0xFF));
                    pcmData.append((byte)(val >> 16 & 0xFF));
                    ++channel;
                }
                ++i;
            }
        }
        return pcmData;
    }

    public StreamInfo readStreamInfo() throws IOException {
        this.readStreamSync();
        Metadata metadata = this.readNextMetadata();
        if (!(metadata instanceof StreamInfo)) {
            throw new IOException("StreamInfo metadata block missing");
        }
        return (StreamInfo)metadata;
    }

    public Metadata[] readMetadata() throws IOException {
        Metadata metadata;
        this.readStreamSync();
        Vector<Metadata> metadataList = new Vector<Metadata>();
        this.metadataLength = 0;
        do {
            metadata = this.readNextMetadata();
            metadataList.add(metadata);
            this.metadataLength += metadata.getLength();
        } while (!metadata.isLast());
        return metadataList.toArray(new Metadata[metadataList.size()]);
    }

    public Metadata[] readMetadata(StreamInfo streamInfo) throws IOException {
        Metadata metadata;
        if (streamInfo.isLast()) {
            return new Metadata[0];
        }
        Vector<Metadata> metadataList = new Vector<Metadata>();
        this.metadataLength = 0;
        do {
            metadata = this.readNextMetadata();
            metadataList.add(metadata);
        } while (!metadata.isLast());
        return metadataList.toArray(new Metadata[metadataList.size()]);
    }

    public void decode() throws IOException {
        this.readMetadata();
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    if (this.callPCMProcessors(this.frame)) continue;
                    throw new EOFException();
                }
                catch (FrameDecodeException e) {
                    ++this.badFrames;
                    continue;
                }
                break;
            }
        }
        catch (EOFException e) {
            this.eof = true;
            return;
        }
    }

    public void decodeFrames() throws IOException {
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    this.callPCMProcessors(this.frame);
                }
                catch (FrameDecodeException e) {
                    ++this.badFrames;
                }
            }
        }
        catch (EOFException e) {
            this.eof = true;
            return;
        }
    }

    public SeekPoint seek(long target_sample) throws IOException {
        if (!(this.inputStream instanceof RandomFileInputStream)) {
            return null;
        }
        RandomFileInputStream rf = (RandomFileInputStream)this.inputStream;
        long stream_length = ((RandomFileInputStream)this.inputStream).getLength();
        int first_frame_offset = this.metadataLength;
        long total_samples = this.streamInfo.getTotalSamples();
        int min_blocksize = this.streamInfo.getMinBlockSize();
        int max_blocksize = this.streamInfo.getMaxBlockSize();
        int min_framesize = this.streamInfo.getMinFrameSize();
        int max_framesize = this.streamInfo.getMaxFrameSize();
        int channels = this.streamInfo.getChannels();
        int bps = this.streamInfo.getBitsPerSample();
        int approx_bytes_per_frame = 0;
        approx_bytes_per_frame = max_framesize > 0 ? max_framesize : (min_blocksize == max_blocksize && min_blocksize > 0 ? min_blocksize * channels * bps / 8 + 64 : 4608 * channels * bps / 8 + 64);
        if (min_blocksize == 0) {
            min_blocksize = max_blocksize / 2;
        }
        if (min_framesize == 0) {
            min_framesize = max_framesize / 2;
        }
        int lower_bound = first_frame_offset;
        long upper_bound = max_framesize > 0 ? stream_length - (long)(max_framesize + 128 + 2) : stream_length - (long)(channels * bps * 65535 / 8 + 128 + 2);
        long pos = -1L;
        if (total_samples > 0L) {
            pos = (long)first_frame_offset + target_sample * (stream_length - (long)first_frame_offset) / total_samples - (long)approx_bytes_per_frame;
        }
        int i = 0;
        boolean needs_seek = pos >= 0L;
        long this_frame_sample = 0L;
        long last_frame_sample = 0L;
        int this_block_size = 0;
        int this_jump = 0;
        int last_jump = 0;
        long last_pos = pos;
        int sample_skip = 0;
        long savedPos = rf.getPosition();
        BitInputStream savedState = this.bitStream;
        this.bitStream = new BitInputStream(rf);
        Frame savedFrame = this.frame;
        this.frame = new Frame();
        while (true) {
            long delta;
            long max_bytes_to_frame;
            if (pos >= upper_bound) {
                pos = upper_bound - 1L;
                needs_seek = true;
            }
            if (pos < (long)lower_bound) {
                pos = lower_bound;
                needs_seek = true;
            }
            if (needs_seek) {
                this.bitStream.reset();
                rf.seek(pos);
                needs_seek = false;
                ++i;
            }
            boolean got_a_frame = false;
            int unparseable_count = 0;
            while (unparseable_count < 20) {
                try {
                    this.findFrameSync();
                    this.readFrame();
                    got_a_frame = true;
                    break;
                }
                catch (Exception exception) {
                    ++unparseable_count;
                }
            }
            if (!got_a_frame) {
                this.restoreState(savedPos, savedState, savedFrame);
                return null;
            }
            if (i >= 30) break;
            this_frame_sample = this.frame.header.sampleNumber;
            this_block_size = this.frame.header.blockSize;
            if (target_sample >= this_frame_sample && target_sample < this_frame_sample + (long)this_block_size) {
                sample_skip = (int)(target_sample - this_frame_sample);
                break;
            }
            if (target_sample < this_frame_sample) {
                if (this_frame_sample - target_sample <= (long)(this_block_size * 10)) {
                    if (this_frame_sample == last_frame_sample && pos < last_pos) {
                        pos -= last_pos - pos;
                    } else {
                        last_pos = pos;
                        pos -= (long)approx_bytes_per_frame;
                    }
                } else {
                    last_pos = pos;
                    long min_bytes_to_frame = (this_frame_sample - target_sample + (long)min_blocksize - 1L) / (long)min_blocksize * (long)min_framesize;
                    max_bytes_to_frame = (this_frame_sample - target_sample + (long)max_blocksize - 1L) / (long)max_blocksize * (long)max_framesize;
                    delta = this_frame_sample - last_frame_sample;
                    if (last_frame_sample > 0L && last_jump > 0 && delta != 0L) {
                        this_jump = (int)((long)last_jump * (this_frame_sample - target_sample) / delta);
                        if (this_jump < 0) {
                            this_jump = -this_jump;
                        }
                    } else {
                        this_jump = delta == 0L ? last_jump + last_jump / 2 : (int)((min_bytes_to_frame + max_bytes_to_frame) / 2L);
                    }
                    if (last_jump > 0 && this_jump >= last_jump) {
                        this_jump = last_jump - approx_bytes_per_frame;
                    }
                    pos = rf.getPosition() - (long)this_jump;
                    last_jump = this_jump;
                }
                needs_seek = true;
            } else if (target_sample > this_frame_sample) {
                last_pos = pos;
                if (target_sample - this_frame_sample <= (long)(min_blocksize * 10)) {
                    pos = rf.getPosition();
                } else {
                    long min_bytes_to_frame = (target_sample - this_frame_sample + (long)max_blocksize - 1L) / (long)max_blocksize * (long)min_framesize;
                    max_bytes_to_frame = (target_sample - this_frame_sample + (long)min_blocksize - 1L) / (long)min_blocksize * (long)max_framesize;
                    delta = this_frame_sample - last_frame_sample;
                    if (last_frame_sample > 0L && last_jump > 0 && delta != 0L) {
                        this_jump = (int)((long)last_jump * (this_frame_sample - target_sample) / delta);
                        if (this_jump < 0) {
                            this_jump = -this_jump;
                        }
                    } else {
                        this_jump = (int)((min_bytes_to_frame + max_bytes_to_frame) / 2L);
                    }
                    if (last_jump > 0 && this_jump >= last_jump) {
                        this_jump = last_jump - approx_bytes_per_frame;
                    }
                    pos = rf.getPosition() + (long)this_jump;
                    last_jump = this_jump;
                    needs_seek = true;
                }
            }
            last_frame_sample = this_frame_sample;
        }
        return new SeekPoint(target_sample - (long)sample_skip, last_pos, sample_skip);
    }

    private void restoreState(long savedPos, BitInputStream savedState, Frame savedFrame) {
        if (!(this.inputStream instanceof RandomFileInputStream)) {
            return;
        }
        try {
            ((RandomFileInputStream)this.inputStream).seek(savedPos);
            this.bitStream = savedState;
            this.frame = savedFrame;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void decode(SeekPoint from, SeekPoint to) throws IOException {
        if (!(this.inputStream instanceof RandomFileInputStream)) {
            throw new IOException("Not a RandomFileInputStream: " + this.inputStream.getClass().getName());
        }
        ((RandomFileInputStream)this.inputStream).seek(from.getStreamOffset());
        this.bitStream.reset();
        this.samplesDecoded = from.getSampleNumber();
        try {
            do {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    this.callPCMProcessors(this.frame);
                }
                catch (FrameDecodeException e) {
                    ++this.badFrames;
                }
            } while (to == null || this.samplesDecoded < to.getSampleNumber());
            return;
        }
        catch (EOFException e) {
            this.eof = true;
            return;
        }
    }

    public Frame readNextFrame() throws IOException {
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    return this.frame;
                }
                catch (FrameDecodeException e) {
                    ++this.badFrames;
                    continue;
                }
                break;
            }
        }
        catch (EOFException e) {
            this.eof = true;
            return null;
        }
    }

    public long getTotalBytesRead() {
        return this.bitStream.getTotalBytesRead();
    }

    private void allocateOutput(int size, int channels) {
        if (size <= this.outputCapacity && channels <= this.outputChannels) {
            return;
        }
        Arrays.fill(this.channelData, null);
        int i = 0;
        while (i < channels) {
            this.channelData[i] = new ChannelData(size);
            ++i;
        }
        this.outputCapacity = size;
        this.outputChannels = channels;
    }

    private void readStreamSync() throws IOException {
        int id = 0;
        int i = 0;
        while (i < 4) {
            int x = this.bitStream.readRawUInt(8);
            if (x == Constants.STREAM_SYNC_STRING[i]) {
                ++i;
                id = 0;
                continue;
            }
            if (x == ID3V2_TAG[id]) {
                i = 0;
                if (++id != 3) continue;
                this.skipID3v2Tag();
                id = 0;
                continue;
            }
            throw new IOException("Could not find Stream Sync");
        }
    }

    public Metadata readNextMetadata() throws IOException {
        Metadata metadata = null;
        boolean isLast = this.bitStream.readRawUInt(1) != 0;
        int type = this.bitStream.readRawUInt(7);
        int length = this.bitStream.readRawUInt(24);
        if (type == 0) {
            metadata = new StreamInfo(this.bitStream, length, isLast);
            if (metadata.getTotalSamples() > 0L) {
                this.streamInfo = metadata;
                this.pcmProcessors.processStreamInfo(this.streamInfo);
            }
        } else {
            metadata = type == 3 ? new SeekTable(this.bitStream, length, isLast) : (type == 2 ? new Application(this.bitStream, length, isLast) : (type == 1 ? new Padding(this.bitStream, length, isLast) : (type == 4 ? new VorbisComment(this.bitStream, length, isLast) : (type == 5 ? new CueSheet(this.bitStream, length, isLast) : (type == 6 ? new Picture(this.bitStream, length, isLast) : new Unknown(this.bitStream, length, isLast))))));
        }
        this.frameListeners.processMetadata(metadata);
        return metadata;
    }

    private void skipID3v2Tag() throws IOException {
        int verMajor = this.bitStream.readRawInt(8);
        int verMinor = this.bitStream.readRawInt(8);
        int flags = this.bitStream.readRawInt(8);
        int skip = 0;
        int i = 0;
        while (i < 4) {
            int x = this.bitStream.readRawUInt(8);
            skip <<= 7;
            skip |= x & 0x7F;
            ++i;
        }
        this.bitStream.readByteBlockAlignedNoCRC(null, skip);
    }

    private void findFrameSync() throws IOException {
        boolean first = true;
        if (this.streamInfo != null && this.streamInfo.getTotalSamples() > 0L && this.samplesDecoded >= this.streamInfo.getTotalSamples()) {
            return;
        }
        if (!this.bitStream.isConsumedByteAligned()) {
            this.bitStream.readRawUInt(this.bitStream.bitsLeftForByteAlignment());
        }
        try {
            while (true) {
                int x;
                if ((x = this.bitStream.readRawUInt(8)) == 255) {
                    this.headerWarmup[0] = (byte)x;
                    x = this.bitStream.peekRawUInt(8);
                    if (x >> 2 == 62) {
                        this.headerWarmup[1] = (byte)this.bitStream.readRawUInt(8);
                        return;
                    }
                }
                if (!first) continue;
                this.frameListeners.processError("FindSync LOST_SYNC: " + Integer.toHexString(x & 0xFF));
                first = false;
            }
        }
        catch (EOFException e) {
            if (!first) {
                this.frameListeners.processError("FindSync LOST_SYNC: Left over data in file");
            }
            return;
        }
    }

    public void readFrame() throws IOException, FrameDecodeException {
        block24: {
            int channel;
            short frameCRC;
            block23: {
                frameCRC = 0;
                frameCRC = CRC16.update(this.headerWarmup[0], frameCRC);
                frameCRC = CRC16.update(this.headerWarmup[1], frameCRC);
                this.bitStream.resetReadCRC16(frameCRC);
                try {
                    this.frame.header = new Header(this.bitStream, this.headerWarmup, this.streamInfo);
                }
                catch (BadHeaderException e) {
                    this.frameListeners.processError("Found bad header: " + e);
                    throw new FrameDecodeException("Bad Frame Header: " + e, e);
                }
                this.allocateOutput(this.frame.header.blockSize, this.frame.header.channels);
                channel = 0;
                while (channel < this.frame.header.channels) {
                    int bps = this.frame.header.bitsPerSample;
                    switch (this.frame.header.channelAssignment) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (channel != 1) break;
                            ++bps;
                            break;
                        }
                        case 2: {
                            if (channel != 0) break;
                            ++bps;
                            break;
                        }
                        case 3: {
                            if (channel != 1) break;
                            ++bps;
                        }
                    }
                    try {
                        this.readSubframe(channel, bps);
                    }
                    catch (IOException e) {
                        this.frameListeners.processError("ReadSubframe: " + e);
                        throw e;
                    }
                    ++channel;
                }
                this.readZeroPadding();
                frameCRC = this.bitStream.getReadCRC16();
                this.frame.setCRC((short)this.bitStream.readRawUInt(16));
                if (frameCRC != this.frame.getCRC()) break block23;
                switch (this.frame.header.channelAssignment) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int i = 0;
                        while (i < this.frame.header.blockSize) {
                            this.channelData[1].getOutput()[i] = this.channelData[0].getOutput()[i] - this.channelData[1].getOutput()[i];
                            ++i;
                        }
                        break block24;
                    }
                    case 2: {
                        int i = 0;
                        while (i < this.frame.header.blockSize) {
                            int[] nArray = this.channelData[0].getOutput();
                            int n = i;
                            nArray[n] = nArray[n] + this.channelData[1].getOutput()[i];
                            ++i;
                        }
                        break block24;
                    }
                    case 3: {
                        int i = 0;
                        while (i < this.frame.header.blockSize) {
                            int mid = this.channelData[0].getOutput()[i];
                            int side = this.channelData[1].getOutput()[i];
                            mid <<= 1;
                            if ((side & 1) != 0) {
                                ++mid;
                            }
                            int left = mid + side;
                            int right = mid - side;
                            this.channelData[0].getOutput()[i] = left >> 1;
                            this.channelData[1].getOutput()[i] = right >> 1;
                            ++i;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            this.frameListeners.processError("CRC Error: " + Integer.toHexString(frameCRC & 0xFFFF) + " vs " + Integer.toHexString(this.frame.getCRC() & 0xFFFF));
            channel = 0;
            while (channel < this.frame.header.channels) {
                int j = 0;
                while (j < this.frame.header.blockSize) {
                    this.channelData[channel].getOutput()[j] = 0;
                    ++j;
                }
                ++channel;
            }
        }
        this.channels = this.frame.header.channels;
        this.channelAssignment = this.frame.header.channelAssignment;
        this.bitsPerSample = this.frame.header.bitsPerSample;
        this.sampleRate = this.frame.header.sampleRate;
        this.blockSize = this.frame.header.blockSize;
        this.samplesDecoded += (long)this.frame.header.blockSize;
    }

    private void readSubframe(int channel, int bps) throws IOException, FrameDecodeException {
        int x = this.bitStream.readRawUInt(8);
        boolean haveWastedBits = (x & 1) != 0;
        x &= 0xFE;
        int wastedBits = 0;
        if (haveWastedBits) {
            wastedBits = this.bitStream.readUnaryUnsigned() + 1;
            bps -= wastedBits;
        }
        if ((x & 0x80) != 0) {
            this.frameListeners.processError("ReadSubframe LOST_SYNC: " + Integer.toHexString(x & 0xFF));
            throw new FrameDecodeException("ReadSubframe LOST_SYNC: " + Integer.toHexString(x & 0xFF));
        }
        if (x == 0) {
            this.frame.subframes[channel] = new ChannelConstant(this.bitStream, this.frame.header, this.channelData[channel], bps, wastedBits);
        } else if (x == 2) {
            this.frame.subframes[channel] = new ChannelVerbatim(this.bitStream, this.frame.header, this.channelData[channel], bps, wastedBits);
        } else {
            if (x < 16) {
                throw new FrameDecodeException("ReadSubframe Bad Subframe Type: " + Integer.toHexString(x & 0xFF));
            }
            if (x <= 24) {
                this.frame.subframes[channel] = new ChannelFixed(this.bitStream, this.frame.header, this.channelData[channel], bps, wastedBits, x >> 1 & 7);
            } else {
                if (x < 64) {
                    throw new FrameDecodeException("ReadSubframe Bad Subframe Type: " + Integer.toHexString(x & 0xFF));
                }
                this.frame.subframes[channel] = new ChannelLPC(this.bitStream, this.frame.header, this.channelData[channel], bps, wastedBits, (x >> 1 & 0x1F) + 1);
            }
        }
        if (haveWastedBits) {
            x = this.frame.subframes[channel].getWastedBits();
            int i = 0;
            while (i < this.frame.header.blockSize) {
                int[] nArray = this.channelData[channel].getOutput();
                int n = i++;
                nArray[n] = nArray[n] << x;
            }
        }
    }

    private void readZeroPadding() throws IOException, FrameDecodeException {
        int zero;
        if (!this.bitStream.isConsumedByteAligned() && (zero = this.bitStream.readRawUInt(this.bitStream.bitsLeftForByteAlignment())) != 0) {
            this.frameListeners.processError("ZeroPaddingError: " + Integer.toHexString(zero));
            throw new FrameDecodeException("ZeroPaddingError: " + Integer.toHexString(zero));
        }
    }

    public long getSamplesDecoded() {
        return this.samplesDecoded;
    }

    public void setSamplesDecoded(long samples) {
        this.samplesDecoded = samples;
    }

    public int getBadFrames() {
        return this.badFrames;
    }

    public boolean isEOF() {
        return this.eof;
    }
}

