/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.apps;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SndPlayer {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("SndPlayer usage:");
            System.out.println("\tjava SndPlayer <sound file names>*");
            System.exit(0);
        }
        int i = 0;
        while (i < args.length) {
            SndPlayer.playAudioFile(args[i]);
            ++i;
        }
        System.exit(0);
    }

    public static void playAudioFile(String fileName) {
        File soundFile = new File(fileName);
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(soundFile);
            SndPlayer.playAudioStream(audioInputStream);
        }
        catch (Exception e) {
            System.out.println("Problem with file " + fileName + ":");
            e.printStackTrace();
        }
    }

    public static void playAudioStream(AudioInputStream audioInputStream) {
        DataLine.Info info;
        AudioFormat audioFormat = audioInputStream.getFormat();
        System.out.println("Play input audio format=" + audioFormat);
        if (audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            System.out.println("Converting audio format to " + newFormat);
            AudioInputStream newStream = AudioSystem.getAudioInputStream(newFormat, audioInputStream);
            audioFormat = newFormat;
            audioInputStream = newStream;
        }
        if (!AudioSystem.isLineSupported(info = new DataLine.Info(SourceDataLine.class, audioFormat))) {
            System.out.println("Play.playAudioStream does not handle this type of audio on this system.");
            return;
        }
        try {
            SourceDataLine dataLine = (SourceDataLine)AudioSystem.getLine(info);
            dataLine.open(audioFormat);
            if (dataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                FloatControl volume = (FloatControl)dataLine.getControl(FloatControl.Type.MASTER_GAIN);
                volume.setValue(100.0f);
            }
            dataLine.start();
            int bufferSize = (int)audioFormat.getSampleRate() * audioFormat.getFrameSize();
            byte[] buffer = new byte[bufferSize];
            try {
                int bytesRead = 0;
                while (bytesRead >= 0) {
                    bytesRead = audioInputStream.read(buffer, 0, buffer.length);
                    if (bytesRead < 0) continue;
                    dataLine.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Play.playAudioStream draining line.");
            dataLine.drain();
            System.out.println("Play.playAudioStream closing line.");
            dataLine.close();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }
}

