/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.apps;

import java.io.FileInputStream;
import java.io.IOException;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.FrameListener;
import org.kc7bfi.jflac.frame.Frame;
import org.kc7bfi.jflac.io.RandomFileInputStream;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.SeekPoint;
import org.kc7bfi.jflac.metadata.StreamInfo;

public class Tester
implements FrameListener {
    private int errors = 0;

    public void test(String inFileName) throws IOException {
        FileInputStream is = new FileInputStream(inFileName);
        FLACDecoder decoder = new FLACDecoder(is);
        decoder.addFrameListener(this);
        decoder.decode();
        System.out.println(String.valueOf(this.errors) + " errors found!");
        is.close();
    }

    public void test2(String inFileName, long time) throws IOException {
        RandomFileInputStream is = new RandomFileInputStream(inFileName);
        FLACDecoder decoder = new FLACDecoder(is);
        decoder.readMetadata();
        StreamInfo si = decoder.getStreamInfo();
        long pos = time * (long)si.getSampleRate();
        System.out.println("Seeking to " + pos + " sample");
        SeekPoint sp = decoder.seek(pos);
        System.out.println("Found point " + sp);
        if (sp != null) {
            decoder.decodeFrames();
        }
        System.out.println(String.valueOf(this.errors) + " errors found!");
        is.close();
    }

    public void processMetadata(Metadata metadata) {
    }

    public void processFrame(Frame frame) {
    }

    public void processError(String msg) {
        ++this.errors;
        System.out.println(msg);
    }

    public static void main(String[] args) {
        try {
            Tester tester = new Tester();
            System.out.println("FLAX Tester for " + args[0]);
            if (args.length > 1) {
                if ("2".equals(args[1]) && args.length > 2) {
                    tester.test2(args[0], Long.parseLong(args[2]));
                }
            } else {
                tester.test(args[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

