/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.frame;

import java.io.IOException;
import org.kc7bfi.jflac.ChannelData;
import org.kc7bfi.jflac.FixedPredictor;
import org.kc7bfi.jflac.FrameDecodeException;
import org.kc7bfi.jflac.frame.Channel;
import org.kc7bfi.jflac.frame.EntropyCodingMethod;
import org.kc7bfi.jflac.frame.EntropyPartitionedRice;
import org.kc7bfi.jflac.frame.EntropyPartitionedRice2;
import org.kc7bfi.jflac.frame.Header;
import org.kc7bfi.jflac.io.BitInputStream;

public class ChannelFixed
extends Channel {
    private static final int MAX_FIXED_ORDER = 4;
    private EntropyCodingMethod entropyCodingMethod;
    private int order;
    private int[] warmup = new int[4];
    private int[] residual;

    public ChannelFixed(BitInputStream is, Header header, ChannelData channelData, int bps, int wastedBits, int order) throws IOException, FrameDecodeException {
        super(header, wastedBits);
        EntropyCodingMethod pr;
        this.residual = channelData.getResidual();
        this.order = order;
        int u = 0;
        while (u < order) {
            this.warmup[u] = is.readRawInt(bps);
            ++u;
        }
        int type = is.readRawUInt(2);
        switch (type) {
            case 0: {
                pr = new EntropyPartitionedRice();
                break;
            }
            case 1: {
                pr = new EntropyPartitionedRice2();
                break;
            }
            default: {
                throw new FrameDecodeException("STREAM_DECODER_UNPARSEABLE_STREAM, type:" + type);
            }
        }
        this.entropyCodingMethod = pr;
        pr.order = is.readRawUInt(4);
        pr.contents = channelData.getPartitionedRiceContents();
        pr.readResidual(is, order, pr.order, header, channelData.getResidual());
        System.arraycopy(this.warmup, 0, channelData.getOutput(), 0, order);
        FixedPredictor.restoreSignal(this.residual, header.blockSize - order, order, channelData.getOutput(), order);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FLACSubframe_Fixed: Order=" + this.order + " PartitionOrder=" + ((EntropyPartitionedRice)this.entropyCodingMethod).order + " WastedBits=" + this.wastedBits);
        int i = 0;
        while (i < this.order) {
            sb.append(" warmup[" + i + "]=" + this.warmup[i]);
            ++i;
        }
        return sb.toString();
    }
}

