/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.metadata;

import java.io.IOException;
import org.kc7bfi.jflac.io.BitInputStream;
import org.kc7bfi.jflac.io.BitOutputStream;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.SeekPoint;

public class SeekTable
extends Metadata {
    private static final int SEEKPOINT_LENGTH_BYTES = 18;
    protected SeekPoint[] points;

    public SeekTable(BitInputStream is, int length, boolean isLast) throws IOException {
        super(isLast, length);
        int numPoints = length / 18;
        this.points = new SeekPoint[numPoints];
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new SeekPoint(is);
            ++i;
        }
        if ((length -= length * 18) > 0) {
            is.readByteBlockAlignedNoCRC(null, length);
        }
    }

    public SeekTable(SeekPoint[] points, boolean isLast) {
        super(isLast, -1);
        this.points = points;
    }

    public void write(BitOutputStream os, boolean isLast) throws IOException {
        os.writeRawUInt(isLast, 1);
        os.writeRawUInt(3, 7);
        os.writeRawUInt(this.calcLength(), 24);
        int i = 0;
        while (i < this.points.length) {
            this.points[i].write(os);
            ++i;
        }
        os.flushByteAligned();
    }

    public int calcLength() {
        return this.points.length * 18;
    }

    public SeekPoint getSeekPoint(int idx) {
        if (idx < 0 || idx >= this.points.length) {
            return null;
        }
        return this.points[idx];
    }

    public SeekPoint seekSeekPoint(long sampleNumber) {
        int idx = 0;
        while (idx < this.points.length) {
            if (this.points[idx].sampleNumber > sampleNumber) {
                if (idx > 0) {
                    return this.points[idx - 1];
                }
                return this.points[idx];
            }
            ++idx;
        }
        return null;
    }

    public int numberOfPoints() {
        return this.points.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SeekTable: points=" + this.points.length + "\n");
        int i = 0;
        while (i < this.points.length) {
            sb.append("\tPoint " + this.points[i].toString() + "\n");
            ++i;
        }
        return sb.toString();
    }
}

