/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.metadata;

import java.io.IOException;
import java.util.Vector;
import org.kc7bfi.jflac.io.BitInputStream;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.VorbisString;

public class VorbisComment
extends Metadata {
    protected byte[] vendorString = new byte[0];
    protected int numComments = 0;
    protected VorbisString[] comments;

    public VorbisComment(BitInputStream is, int length, boolean isLast) throws IOException {
        super(isLast, length);
        int len = is.readRawIntLittleEndian();
        this.vendorString = new byte[len];
        is.readByteBlockAlignedNoCRC(this.vendorString, this.vendorString.length);
        this.numComments = is.readRawIntLittleEndian();
        if (this.numComments > 0) {
            this.comments = new VorbisString[this.numComments];
        }
        int i = 0;
        while (i < this.numComments) {
            this.comments[i] = new VorbisString(is);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("VendorString '" + new String(this.vendorString) + "'\n");
        sb.append("VorbisComment (count=" + this.numComments + ")");
        int i = 0;
        while (i < this.numComments) {
            sb.append("\n\t" + this.comments[i].toString());
            ++i;
        }
        return sb.toString();
    }

    public String[] getCommentByName(String key) {
        if (this.numComments == 0 || key == null) {
            return null;
        }
        Vector<String> sbuff = new Vector<String>();
        int i = 0;
        while (i < this.comments.length) {
            String comment = this.comments[i].toString();
            int eqpos = comment.indexOf(61);
            if (eqpos != -1 && comment.substring(0, eqpos).equalsIgnoreCase(key)) {
                sbuff.add(comment.substring(eqpos + 1, comment.length()));
            }
            ++i;
        }
        return sbuff.toArray(new String[0]);
    }
}

