/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.sbr.HuffmanTables;
import net.sourceforge.jaad.aac.sbr.SBR;
import net.sourceforge.jaad.aac.sbr.SBRConstants;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.Constants;

class ChannelData
implements SBRConstants,
HuffmanTables {
    private static final int[] LOG2TABLE = new int[]{0, 0, 1, 2, 2, 3, 3, 3, 3, 4};
    int frameClass;
    int pointer;
    private boolean addHarmonicFlag;
    private boolean addHarmonicFlagPrev;
    boolean[] addHarmonic = new boolean[64];
    boolean[] addHarmonicPrev = new boolean[64];
    private int[] relBord = new int[9];
    private int[] relBord0 = new int[9];
    private int[] relBord1 = new int[9];
    private int rel0;
    private int rel1;
    private boolean[] dfEnv = new boolean[9];
    private boolean[] dfNoise = new boolean[3];
    int[] invfMode = new int[5];
    int[] invfModePrev = new int[5];
    boolean ampRes;
    int[] t_E = new int[6];
    int[] tEtmp = new int[6];
    int[] t_Q = new int[3];
    int L_E;
    int L_E_prev;
    int L_Q;
    boolean[] f = new boolean[6];
    private boolean fPrev;
    float[][] gTempPrev = new float[5][64];
    float[][] qTempPrev = new float[5][64];
    int gqIndex = 0;
    int[][] E = new int[64][5];
    private int[] E_prev = new int[64];
    float[][] E_orig = new float[64][5];
    float[][] E_curr = new float[64][5];
    int[][] Q = new int[64][2];
    int[] Q_prev = new int[64];
    float[][] Q_div = new float[64][2];
    float[][] Q_div2 = new float[64][2];
    private int absBordLead;
    private int absBordTrail;
    int prevEnvIsShort;
    int l_A;
    float[][][] Xsbr;
    float[] bwArray = new float[64];
    float[] bwArrayPrev = new float[64];
    int indexNoisePrev;
    int psiIsPrev;

    ChannelData() {
        this.Xsbr = new float[40][64][2];
    }

    void decodeGrid(BitStream in) throws AACException {
        int savedL_E = this.L_E;
        int savedL_Q = this.L_Q;
        int savedFrameClass = this.frameClass;
        int envCount = 0;
        this.frameClass = in.readBits(2);
        switch (this.frameClass) {
            case 0: {
                int x = in.readBits(2);
                envCount = Math.min(1 << x, 5);
                boolean b = in.readBool();
                for (int i = 0; i < envCount; ++i) {
                    this.f[i] = b;
                }
                this.absBordLead = 0;
                this.absBordTrail = 16;
                break;
            }
            case 1: {
                int i;
                int absBord0 = in.readBits(2) + 16;
                envCount = in.readBits(2) + 1;
                for (i = 0; i < envCount - 1; ++i) {
                    this.relBord[i] = 2 * in.readBits(2) + 2;
                }
                this.pointer = in.readBits(LOG2TABLE[envCount + 1]);
                for (i = 0; i < envCount; ++i) {
                    this.f[envCount - i - 1] = in.readBool();
                }
                this.absBordLead = 0;
                this.absBordTrail = absBord0;
                break;
            }
            case 2: {
                int i;
                int absBord0 = in.readBits(2);
                envCount = in.readBits(2) + 1;
                for (i = 0; i < envCount - 1; ++i) {
                    this.relBord[i] = 2 * in.readBits(2) + 2;
                }
                int x = LOG2TABLE[envCount + 1];
                this.pointer = in.readBits(x);
                for (i = 0; i < envCount; ++i) {
                    this.f[i] = in.readBool();
                }
                this.absBordLead = absBord0;
                this.absBordTrail = 16;
                break;
            }
            case 3: {
                int i;
                int absBord0 = in.readBits(2);
                int absBord1 = in.readBits(2) + 16;
                this.rel0 = in.readBits(2);
                this.rel1 = in.readBits(2);
                envCount = Math.min(5, this.rel0 + this.rel1 + 1);
                for (i = 0; i < this.rel0; ++i) {
                    this.relBord0[i] = 2 * in.readBits(2) + 2;
                }
                for (i = 0; i < this.rel1; ++i) {
                    this.relBord1[i] = 2 * in.readBits(2) + 2;
                }
                int x = LOG2TABLE[this.rel0 + this.rel1 + 2];
                this.pointer = in.readBits(x);
                for (i = 0; i < envCount; ++i) {
                    this.f[i] = in.readBool();
                }
                this.absBordLead = absBord0;
                this.absBordTrail = absBord1;
            }
        }
        this.L_E = this.frameClass == 3 ? Math.min(envCount, 5) : Math.min(envCount, 4);
        if (this.L_E <= 0) {
            throw new AACException("L_E out of range: " + this.L_E);
        }
        this.L_Q = this.L_E > 1 ? 2 : 1;
        if (!this.envelopeTimeBorderVector()) {
            Constants.LOGGER.warning("envelopeTimeBorderVector failed");
            this.frameClass = savedFrameClass;
            this.L_E = savedL_E;
            this.L_Q = savedL_Q;
        }
        this.noiseFloorTimeBorderVector();
    }

    void copyGrid(ChannelData cd) {
        this.frameClass = cd.frameClass;
        this.L_E = cd.L_E;
        this.L_Q = cd.L_Q;
        this.pointer = cd.pointer;
        System.arraycopy(cd.t_E, 0, this.t_E, 0, this.L_E + 1);
        System.arraycopy(cd.f, 0, this.f, 0, this.L_E + 1);
        System.arraycopy(cd.t_Q, 0, this.t_Q, 0, this.L_Q + 1);
    }

    void decodeDTDF(BitStream in) throws AACException {
        int i;
        for (i = 0; i < this.L_E; ++i) {
            this.dfEnv[i] = in.readBool();
        }
        for (i = 0; i < this.L_Q; ++i) {
            this.dfNoise[i] = in.readBool();
        }
    }

    void decodeInvfMode(BitStream in, int len) throws AACException {
        for (int i = 0; i < len; ++i) {
            this.invfMode[i] = in.readBits(2);
        }
    }

    void copyInvfMode(ChannelData cd, int len) {
        System.arraycopy(cd.invfMode, 0, this.invfMode, 0, len);
    }

    void decodeSinusoidalCoding(BitStream in, int len) throws AACException {
        this.addHarmonicFlag = in.readBool();
        if (this.addHarmonicFlag) {
            for (int i = 0; i < len; ++i) {
                this.addHarmonic[i] = in.readBool();
            }
        }
    }

    void decodeEnvelope(BitStream in, SBR sbr, int ch, boolean coupling, boolean ampRes) throws AACException {
        int[][] huffF;
        int[][] huffT;
        int delta;
        ampRes = this.L_E == 1 && this.frameClass == 0 ? false : ampRes;
        int bits = 7 - (coupling && ch == 1 ? 1 : 0) - (ampRes ? 1 : 0);
        if (coupling && ch == 1) {
            delta = 1;
            if (ampRes) {
                huffT = T_HUFFMAN_ENV_BAL_3_0DB;
                huffF = F_HUFFMAN_ENV_BAL_3_0DB;
            } else {
                huffT = T_HUFFMAN_ENV_BAL_1_5DB;
                huffF = F_HUFFMAN_ENV_BAL_1_5DB;
            }
        } else {
            delta = 0;
            if (ampRes) {
                huffT = T_HUFFMAN_ENV_3_0DB;
                huffF = F_HUFFMAN_ENV_3_0DB;
            } else {
                huffT = T_HUFFMAN_ENV_1_5DB;
                huffF = F_HUFFMAN_ENV_1_5DB;
            }
        }
        for (int i = 0; i < this.L_E; ++i) {
            int j;
            if (this.dfEnv[i]) {
                for (j = 0; j < sbr.n[this.f[i] ? 1 : 0]; ++j) {
                    this.E[j][i] = this.decodeHuffman(in, huffT) << delta;
                }
                continue;
            }
            this.E[0][i] = in.readBits(bits) << delta;
            for (j = 1; j < sbr.n[this.f[i] ? 1 : 0]; ++j) {
                this.E[j][i] = this.decodeHuffman(in, huffF) << delta;
            }
        }
        this.extractEnvelopeData(sbr);
    }

    void decodeNoise(BitStream in, SBR sbr, int ch, boolean coupling) throws AACException {
        int[][] huffF;
        int[][] huffT;
        int delta;
        if (coupling && ch == 1) {
            delta = 1;
            huffT = T_HUFFMAN_NOISE_BAL_3_0DB;
            huffF = F_HUFFMAN_ENV_BAL_3_0DB;
        } else {
            delta = 0;
            huffT = T_HUFFMAN_NOISE_3_0DB;
            huffF = F_HUFFMAN_ENV_3_0DB;
        }
        int len = sbr.N_Q;
        for (int i = 0; i < this.L_Q; ++i) {
            int j;
            if (this.dfNoise[i]) {
                for (j = 0; j < len; ++j) {
                    this.Q[j][i] = this.decodeHuffman(in, huffT) << delta;
                }
                continue;
            }
            this.Q[0][i] = in.readBits(5) << delta;
            for (j = 1; j < len; ++j) {
                this.Q[j][i] = this.decodeHuffman(in, huffF) << delta;
            }
        }
        this.extractNoiseFloorData(sbr);
    }

    private int decodeHuffman(BitStream in, int[][] table) throws AACException {
        int index = 0;
        while (index >= 0) {
            int bit = in.readBit();
            index = table[index][bit];
        }
        return index + 64;
    }

    public boolean hasHarmonicPrev() {
        return this.addHarmonicFlagPrev;
    }

    private boolean envelopeTimeBorderVector() {
        int i;
        for (i = 0; i < 6; ++i) {
            this.tEtmp[i] = 0;
        }
        this.tEtmp[0] = 2 * this.absBordLead;
        this.tEtmp[this.L_E] = 2 * this.absBordTrail;
        block0 : switch (this.frameClass) {
            case 0: {
                switch (this.L_E) {
                    case 4: {
                        int tmp = 4;
                        this.tEtmp[3] = 6 * tmp;
                        this.tEtmp[2] = 4 * tmp;
                        this.tEtmp[1] = 2 * tmp;
                        break block0;
                    }
                    case 2: {
                        this.tEtmp[1] = 16;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (this.L_E <= 1) break;
                int tmp = this.L_E;
                int border = this.absBordTrail;
                for (i = 0; i < this.L_E - 1; ++i) {
                    if (border < this.relBord[i]) {
                        return false;
                    }
                    this.tEtmp[--tmp] = 2 * (border -= this.relBord[i]);
                }
                break;
            }
            case 2: {
                if (this.L_E <= 1) break;
                int tmp = 1;
                int border = this.absBordLead;
                for (i = 0; i < this.L_E - 1; ++i) {
                    if (2 * (border += this.relBord[i]) + 2 > 40) {
                        return false;
                    }
                    this.tEtmp[tmp++] = 2 * border;
                }
                break;
            }
            case 3: {
                int border;
                int tmp;
                if (this.rel0 > 0) {
                    tmp = 1;
                    border = this.absBordLead;
                    for (i = 0; i < this.rel0; ++i) {
                        if (2 * (border += this.relBord0[i]) + 2 > 40) {
                            return false;
                        }
                        this.tEtmp[tmp++] = 2 * border;
                    }
                }
                if (this.rel1 <= 0) break;
                tmp = this.L_E;
                border = this.absBordTrail;
                for (i = 0; i < this.rel1; ++i) {
                    if (border < this.relBord1[i]) {
                        return false;
                    }
                    this.tEtmp[--tmp] = 2 * (border -= this.relBord1[i]);
                }
                break;
            }
        }
        System.arraycopy(this.tEtmp, 0, this.t_E, 0, 6);
        return true;
    }

    private void noiseFloorTimeBorderVector() {
        this.t_Q[0] = this.t_E[0];
        if (this.L_E == 1) {
            this.t_Q[1] = this.t_E[1];
            this.t_Q[2] = 0;
        } else {
            this.t_Q[1] = this.t_E[this.findMiddleBorder()];
            this.t_Q[2] = this.t_E[this.L_E];
        }
    }

    private int findMiddleBorder() {
        int r = 0;
        switch (this.frameClass) {
            case 0: {
                r = this.L_E / 2;
                break;
            }
            case 2: {
                if (this.pointer == 0) {
                    r = 1;
                    break;
                }
                if (this.pointer == 1) {
                    r = this.L_E - 1;
                    break;
                }
                r = this.pointer - 1;
                break;
            }
            case 1: 
            case 3: {
                r = this.pointer > 1 ? this.L_E + 1 - this.pointer : this.L_E - 1;
            }
        }
        return r > 0 ? r : 0;
    }

    private void extractEnvelopeData(SBR sbr) {
        for (int i = 0; i < this.L_E; ++i) {
            int j;
            if (this.dfEnv[i]) {
                int k;
                boolean g;
                boolean bl = g = i == 0 ? this.fPrev : this.f[i - 1];
                if (this.f[i] == g) {
                    for (j = 0; j < sbr.n[this.f[i] ? 1 : 0]; ++j) {
                        int[] nArray = this.E[j];
                        int n = i;
                        nArray[n] = nArray[n] + (i == 0 ? this.E_prev[j] : this.E[j][i - 1]);
                    }
                    continue;
                }
                if (g && !this.f[i]) {
                    for (j = 0; j < sbr.n[this.f[i] ? 1 : 0]; ++j) {
                        for (k = 0; k < sbr.N_high; ++k) {
                            if (sbr.ftRes[1][k] != sbr.ftRes[0][j]) continue;
                            int[] nArray = this.E[j];
                            int n = i;
                            nArray[n] = nArray[n] + (i == 0 ? this.E_prev[k] : this.E[k][i - 1]);
                        }
                    }
                    continue;
                }
                if (g || !this.f[i]) continue;
                for (j = 0; j < sbr.n[this.f[i] ? 1 : 0]; ++j) {
                    for (k = 0; k < sbr.N_low; ++k) {
                        if (sbr.ftRes[0][k] > sbr.ftRes[1][j] || sbr.ftRes[1][j] >= sbr.ftRes[0][k + 1]) continue;
                        int[] nArray = this.E[j];
                        int n = i;
                        nArray[n] = nArray[n] + (i == 0 ? this.E_prev[k] : this.E[k][i - 1]);
                    }
                }
                continue;
            }
            for (j = 1; j < sbr.n[this.f[i] ? 1 : 0]; ++j) {
                int[] nArray = this.E[j];
                int n = i;
                nArray[n] = nArray[n] + this.E[j - 1][i];
                if (this.E[j][i] >= 0) continue;
                this.E[j][i] = 0;
            }
        }
    }

    private void extractNoiseFloorData(SBR sbr) {
        int len = sbr.N_Q;
        for (int i = 0; i < this.L_Q; ++i) {
            int j;
            if (this.dfNoise[i]) {
                if (i == 0) {
                    for (j = 0; j < len; ++j) {
                        this.Q[j][i] = this.Q_prev[j] + this.Q[j][0];
                    }
                    continue;
                }
                for (j = 0; j < len; ++j) {
                    int[] nArray = this.Q[j];
                    int n = i;
                    nArray[n] = nArray[n] + this.Q[j][i - 1];
                }
                continue;
            }
            for (j = 1; j < len; ++j) {
                int[] nArray = this.Q[j];
                int n = i;
                nArray[n] = nArray[n] + this.Q[j - 1][i];
            }
        }
    }

    void savePreviousData() {
        this.L_E_prev = this.L_E;
        this.fPrev = this.f[this.L_E - 1];
        for (int i = 0; i < 49; ++i) {
            this.E_prev[i] = this.E[i][this.L_E - 1];
            this.Q_prev[i] = this.Q[i][this.L_Q - 1];
        }
        System.arraycopy(this.addHarmonic, 0, this.addHarmonicPrev, 0, 49);
        this.addHarmonicFlagPrev = this.addHarmonicFlag;
        this.prevEnvIsShort = this.l_A == this.L_E ? 0 : -1;
    }

    void saveMatrix() {
        int j;
        int i;
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 64; ++j) {
                this.Xsbr[i][j][0] = this.Xsbr[i + 32][j][0];
                this.Xsbr[i][j][1] = this.Xsbr[i + 32][j][1];
            }
        }
        for (i = 8; i < 40; ++i) {
            for (j = 0; j < 64; ++j) {
                this.Xsbr[i][j][0] = 0.0f;
                this.Xsbr[i][j][1] = 0.0f;
            }
        }
    }
}

