/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr;

import net.sourceforge.jaad.aac.sbr.Filterbank;
import net.sourceforge.jaad.aac.sbr.FilterbankTables;

class QMFAnalysis
implements FilterbankTables {
    private final Filterbank filterBank;
    private final float[] x;
    private final float[] sum;
    private final float[][] tmpIn;
    private final float[][] tmpOut;
    private int xIndex;

    QMFAnalysis(Filterbank filterBank, int channels) {
        this.filterBank = filterBank;
        this.x = new float[20 * channels];
        this.sum = new float[64];
        this.tmpIn = new float[32][2];
        this.tmpOut = new float[32][2];
        this.xIndex = 0;
    }

    void performAnalysis32(float[] in, float[][][] out, int offset, int kx, int len) {
        int off = 0;
        for (int l = 0; l < len; ++l) {
            int n;
            for (n = 31; n >= 0; --n) {
                this.x[this.xIndex + n] = in[off];
                this.x[this.xIndex + n + 320] = in[off];
                ++off;
            }
            for (n = 0; n < 64; ++n) {
                this.sum[n] = this.x[this.xIndex + n] * QMF_C[2 * n] + this.x[this.xIndex + n + 64] * QMF_C[2 * (n + 64)] + this.x[this.xIndex + n + 128] * QMF_C[2 * (n + 128)] + this.x[this.xIndex + n + 192] * QMF_C[2 * (n + 192)] + this.x[this.xIndex + n + 256] * QMF_C[2 * (n + 256)];
            }
            this.xIndex -= 32;
            if (this.xIndex < 0) {
                this.xIndex = 288;
            }
            this.tmpIn[31][1] = this.sum[1];
            this.tmpIn[0][0] = this.sum[0];
            for (n = 1; n < 31; ++n) {
                this.tmpIn[31 - n][1] = this.sum[n + 1];
                this.tmpIn[n][0] = -this.sum[64 - n];
            }
            this.tmpIn[0][1] = this.sum[32];
            this.tmpIn[31][0] = -this.sum[33];
            this.filterBank.computeDCT4Kernel(this.tmpIn, this.tmpOut);
            for (n = 0; n < 16; ++n) {
                if (2 * n + 1 < kx) {
                    out[l + offset][2 * n][0] = 2.0f * this.tmpOut[n][0];
                    out[l + offset][2 * n][1] = 2.0f * this.tmpOut[n][1];
                    out[l + offset][2 * n + 1][0] = -2.0f * this.tmpOut[31 - n][1];
                    out[l + offset][2 * n + 1][1] = -2.0f * this.tmpOut[31 - n][0];
                    continue;
                }
                if (2 * n < kx) {
                    out[l + offset][2 * n][0] = 2.0f * this.tmpOut[n][0];
                    out[l + offset][2 * n][1] = 2.0f * this.tmpOut[n][1];
                } else {
                    out[l + offset][2 * n][0] = 0.0f;
                    out[l + offset][2 * n][1] = 0.0f;
                }
                out[l + offset][2 * n + 1][0] = 0.0f;
                out[l + offset][2 * n + 1][1] = 0.0f;
            }
        }
    }
}

