/*
 * Decompiled with CFR 0.152.
 */
package openmods.codecs.adapters;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;
import openmods.codecs.Log;
import openmods.codecs.adapters.CodecAacBase;

public class CodecADTS
extends CodecAacBase {
    private ADTSDemultiplexer adts;

    @Override
    protected void initializeStream(URL url, DataInputStream in) throws IOException {
        this.adts = new ADTSDemultiplexer(in);
    }

    @Override
    protected byte[] getDecoderSpecificInfo() {
        return this.adts.getDecoderSpecificInfo();
    }

    @Override
    protected void validateFormat(URL url) {
        AudioFormat headerFormat = new AudioFormat(this.adts.getSampleFrequency(), 16, this.adts.getChannelCount(), true, true);
        if (!headerFormat.matches(this.format)) {
            Log.warn("Stream %s header declared different format than buffer", url);
        }
    }

    @Override
    protected byte[] readNextFrame() throws IOException {
        return this.adts.readNextFrame();
    }

    @Override
    protected void cleanupSpecific() {
        this.adts = null;
    }
}

