/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import openmods.structured.Command;
import openmods.structured.ICustomCreateData;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureContainerFactory;
import openmods.structured.IStructureElement;
import openmods.structured.IStructureObserver;
import openmods.structured.StructuredData;

public abstract class StructuredDataSlave<C extends IStructureContainer<E>, E extends IStructureElement>
extends StructuredData<C, E> {
    public final IStructureContainerFactory<C> factory;

    protected StructuredDataSlave(IStructureContainerFactory<C> factory, IStructureObserver<C, E> observer) {
        super(observer);
        this.factory = factory;
    }

    protected StructuredDataSlave(IStructureContainerFactory<C> factory) {
        this.factory = factory;
    }

    protected abstract void onConsistencyCheckFail();

    public void interpretCommandList(List<Command> commands) {
        HashMultimap updatedContainers = HashMultimap.create();
        boolean isStructureUpdated = false;
        this.observer.onUpdateStarted();
        for (Command command : commands) {
            try {
                Object containers;
                Command msg;
                if (command.isEnd()) break;
                if (command instanceof Command.ConsistencyCheck) {
                    int maxElementId;
                    msg = (Command.ConsistencyCheck)command;
                    containers = this.containerToElement.keySet();
                    int containerCount = containers.size();
                    int minContainerId = containerCount == 0 ? 0 : (Integer)containers.first();
                    int maxContainerId = containerCount == 0 ? 0 : (Integer)containers.last();
                    int elementCount = this.elements.size();
                    int minElementId = elementCount == 0 ? 0 : (Integer)this.elements.firstKey();
                    int n = maxElementId = elementCount == 0 ? 0 : (Integer)this.elements.lastKey();
                    if (msg.containerCount == containerCount && msg.minContainerId == minContainerId && msg.maxContainerId == maxContainerId && msg.elementCount == elementCount && msg.minElementId == minElementId && msg.maxElementId == maxElementId) continue;
                    throw new ConsistencyCheckFailed("Validation packet not matched");
                }
                if (command instanceof Command.Reset) {
                    this.removeAll();
                    isStructureUpdated = true;
                    continue;
                }
                if (command instanceof Command.Create) {
                    msg = (Command.Create)command;
                    containers = Sets.newTreeSet();
                    TreeSet elements = Sets.newTreeSet();
                    ByteArrayDataInput input = ByteStreams.newDataInput((byte[])((Command.Create)msg).containerPayload);
                    for (Command.ContainerInfo info : ((Command.Create)msg).containers) {
                        SortedSet<Integer> newElementsId = this.createAndAddContainer(input, info.type, info.id, info.start);
                        elements.addAll(newElementsId);
                        updatedContainers.putAll((Object)info.id, newElementsId);
                        containers.add(info.id);
                    }
                    if (input.skipBytes(1) != 0) {
                        throw new ConsistencyCheckFailed("Container payload not fully consumed");
                    }
                    this.readElementPayload(elements, ((Command.Create)msg).elementPayload);
                    isStructureUpdated = true;
                    continue;
                }
                if (command instanceof Command.Delete) {
                    msg = (Command.Delete)command;
                    containers = ((Command.Delete)msg).idList.iterator();
                    while (containers.hasNext()) {
                        int i = (Integer)containers.next();
                        this.removeContainer(i);
                    }
                    isStructureUpdated = true;
                    continue;
                }
                if (!(command instanceof Command.Update)) continue;
                msg = (Command.Update)command;
                this.readElementPayload(((Command.Update)msg).idList, ((Command.Update)msg).elementPayload);
                for (Integer elementId : ((Command.Update)msg).idList) {
                    int containerId = this.elementToContainer.get(elementId.intValue());
                    if (containerId == -1) {
                        throw new ConsistencyCheckFailed("Orphaned element %d", elementId);
                    }
                    updatedContainers.put((Object)containerId, (Object)elementId);
                }
            }
            catch (ConsistencyCheckFailed e) {
                this.onConsistencyCheckFail();
                break;
            }
        }
        if (isStructureUpdated) {
            this.observer.onStructureUpdate();
        }
        for (Map.Entry entry : updatedContainers.asMap().entrySet()) {
            Integer containerId = (Integer)entry.getKey();
            IStructureContainer container = (IStructureContainer)this.containers.get(containerId);
            this.observer.onContainerUpdated(containerId, container);
            for (Integer elementId : (Collection)entry.getValue()) {
                IStructureElement element = (IStructureElement)this.elements.get(elementId);
                this.observer.onElementUpdated(containerId, container, elementId, element);
            }
        }
        if (!updatedContainers.isEmpty()) {
            this.observer.onDataUpdate();
        }
        this.observer.onUpdateFinished();
    }

    private SortedSet<Integer> createAndAddContainer(ByteArrayDataInput input, int type, int containerId, int start) {
        C container = this.factory.createContainer(type);
        try {
            if (container instanceof ICustomCreateData) {
                ((ICustomCreateData)container).readCustomDataFromStream((DataInput)input);
            }
        }
        catch (IOException e) {
            throw new ConsistencyCheckFailed(e, "Failed to read element %d, type %d", containerId, type);
        }
        if (this.containerToElement.containsEntry((Object)containerId, (Object)start)) {
            throw new ConsistencyCheckFailed("Container %d already exists", containerId);
        }
        this.addContainer(containerId, container, start);
        return this.containerToElement.get((Object)containerId);
    }

    private void readElementPayload(SortedSet<Integer> ids, byte[] payload) {
        try {
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])payload);
            for (Integer id : ids) {
                IStructureElement element = (IStructureElement)this.elements.get(id);
                if (element == null) {
                    throw new ConsistencyCheckFailed("Element %d not found", id);
                }
                element.readFromStream((DataInput)input);
            }
            if (input.skipBytes(1) != 0) {
                throw new ConsistencyCheckFailed("Element payload not fully consumed");
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class ConsistencyCheckFailed
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ConsistencyCheckFailed(String message) {
            super(message);
        }

        public ConsistencyCheckFailed(String format, Object ... args) {
            super(String.format(format, args));
        }

        public ConsistencyCheckFailed(Throwable cause, String format, Object ... args) {
            super(String.format(format, args), cause);
        }
    }
}

