/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import com.google.common.base.Strings;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openmods.geometry.Box2d;
import openmods.structured.StructureField;
import openmods.utils.render.RenderUtils;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.drawable.DrawableType;
import openperipheral.addons.glasses.utils.RenderState;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.ScriptObject;
import org.lwjgl.opengl.GL11;

@ScriptObject
@AdapterSourceName(value="glasses_icon")
public class ItemIcon
extends Drawable {
    private static final int BASE_HEIGHT = 16;
    private static final int BASE_WIDTH = 16;
    private ItemStack dummyStack;
    @Property
    @StructureField
    public float x;
    @Property
    @StructureField
    public float y;
    @SideOnly(value=Side.CLIENT)
    private RenderItem renderItem;
    private ItemStack drawStack;
    @Property
    @StructureField
    public float scale = 1.0f;
    @Property
    @StructureField
    public String itemId;
    @Property
    @StructureField
    public int meta;
    @Property
    @StructureField
    public float damageBar;
    @Property
    @StructureField
    public String label;

    ItemIcon() {
    }

    public ItemIcon(float x, float y, String itemId, int meta) {
        this.x = x;
        this.y = y;
        this.itemId = itemId;
        this.meta = meta;
    }

    @SideOnly(value=Side.CLIENT)
    private RenderItem getRenderItem() {
        if (this.renderItem == null) {
            this.renderItem = new RenderItem();
        }
        return this.renderItem;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawContents(RenderState renderState, float partialTicks) {
        renderState.enableTexture();
        renderState.enableDepthTest();
        renderState.enableCullFace();
        renderState.disableLight();
        renderState.setColor(0xFFFFFF, 1.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        RenderItem renderItem = this.getRenderItem();
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        renderItem.func_82406_b(minecraft.field_71466_p, textureManager, this.drawStack, 0, 0);
        if (this.damageBar > 0.0f || !Strings.isNullOrEmpty((String)this.label)) {
            renderItem.func_94148_a(minecraft.field_71466_p, textureManager, this.dummyStack, 0, 0, this.label);
        }
        RenderUtils.disableLightmap();
        renderState.readState();
    }

    @Override
    public DrawableType getTypeEnum() {
        return DrawableType.ITEM;
    }

    @Override
    public boolean isVisible() {
        return this.drawStack != null;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.drawStack = ItemIcon.findDrawStack(this.itemId, this.meta);
        int damage = (int)(this.damageBar * (float)Items.field_151012_L.func_77612_l());
        this.dummyStack = new ItemStack(Items.field_151012_L, 1, damage);
        int width = Math.round(16.0f * this.scale);
        int height = Math.round(16.0f * this.scale);
        this.setBoundingBox(Box2d.fromOriginAndSize((float)this.x, (float)this.y, (float)width, (float)height));
    }

    private static ItemStack findDrawStack(String itemId, int meta) {
        if (Strings.isNullOrEmpty((String)itemId)) {
            return null;
        }
        String[] itemSplit = itemId.split(":");
        if (itemSplit.length != 2) {
            return null;
        }
        Item item = GameRegistry.findItem((String)itemSplit[0], (String)itemSplit[1]);
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, meta);
    }
}

