/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;
import openmods.structured.StructuredDataMaster;
import openperipheral.addons.glasses.IContainer;
import openperipheral.addons.glasses.IOwnerProxy;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.api.architecture.IArchitecture;
import openperipheral.api.helpers.Index;

public abstract class DrawableContainerMaster
extends StructuredDataMaster<Drawable, IStructureElement>
implements IContainer<Drawable> {
    protected final long guid;
    private final IOwnerProxy ownerProxy = new IOwnerProxy(){

        @Override
        public void removeContainer(int containerId) {
            DrawableContainerMaster.this.removeContainer(containerId);
        }

        @Override
        public void markElementModified(int elementId) {
            DrawableContainerMaster.this.markElementModified(elementId);
        }
    };

    public DrawableContainerMaster(long guid) {
        this.guid = guid;
    }

    @Override
    public synchronized void clear() {
        for (Drawable drawable : this.containers.values()) {
            drawable.setDeleted();
        }
        this.removeAll();
    }

    public TerminalEvent.Data createFullDataEvent() {
        TerminalEvent.Data result = this.createDataEvent();
        this.appendFullCommands((List)result.commands);
        return result;
    }

    public TerminalEvent.Data createUpdateDataEvent() {
        TerminalEvent.Data result = this.createDataEvent();
        this.appendUpdateCommands((List)result.commands);
        return result;
    }

    @Override
    public Drawable addObject(Drawable drawable) {
        int containerId = this.addContainer((IStructureContainer)drawable);
        drawable.setId(containerId);
        drawable.setOwner(this.ownerProxy);
        return drawable;
    }

    @Override
    public Drawable getById(Index id) {
        return (Drawable)((Object)this.containers.get(id.value));
    }

    @Override
    public Set<Index> getAllIds(IArchitecture access) {
        HashSet indices = Sets.newHashSet();
        Iterator iterator = this.containers.keySet().iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            indices.add(access.createIndex(value));
        }
        return indices;
    }

    @Override
    public Map<Index, Drawable> getAllObjects(IArchitecture access) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry e : this.containers.entrySet()) {
            result.put(access.createIndex(((Integer)e.getKey()).intValue()), e.getValue());
        }
        return result;
    }

    protected abstract TerminalEvent.Data createDataEvent();

    public abstract TerminalEvent.Clear createClearPacket();

    public static class Private
    extends DrawableContainerMaster {
        public Private(long guid) {
            super(guid);
        }

        @Override
        protected TerminalEvent.Data createDataEvent() {
            return new TerminalEvent.PrivateDrawableData(this.guid);
        }

        @Override
        public TerminalEvent.Clear createClearPacket() {
            return new TerminalEvent.PrivateClear(this.guid);
        }
    }

    public static class Public
    extends DrawableContainerMaster {
        public Public(long guid) {
            super(guid);
        }

        @Override
        protected TerminalEvent.Data createDataEvent() {
            return new TerminalEvent.PublicDrawableData(this.guid);
        }

        @Override
        public TerminalEvent.Clear createClearPacket() {
            return new TerminalEvent.PublicClear(this.guid);
        }
    }
}

