/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import openmods.whodunit.Log;
import openmods.whodunit.data.CallCounter;
import openmods.whodunit.data.CallMarker;
import openmods.whodunit.data.graph.GraphSerializer;
import openmods.whodunit.data.graph.GraphVisitor;

public class CallCollector {
    public static final BlockingQueue<CallMarker> CALLS = Queues.newLinkedBlockingDeque();
    private static final Worker WORKER = new Worker();

    public static void registerCall(int location) {
        CALLS.add(new CallMarker(location));
    }

    public static void startWorker() {
        WORKER.setName("Call collector thread");
        WORKER.setDaemon(true);
        WORKER.start();
    }

    public static void resetData() {
        WORKER.resetData();
    }

    public static void visitData(GraphVisitor visitor, Set<Integer> locations) {
        GraphSerializer serializer = new GraphSerializer();
        for (int location : locations) {
            WORKER.visitData(location, serializer, visitor);
        }
        visitor.finish();
    }

    private static class Worker
    extends Thread {
        private final Map<StackTraceElement, CallCounter> callMap = Maps.newHashMap();
        private final Multimap<Integer, StackTraceElement> locationRoots = HashMultimap.create();

        private Worker() {
        }

        private CallCounter getCounter(StackTraceElement el) {
            CallCounter result = this.callMap.get(el);
            if (result == null) {
                result = new CallCounter();
                this.callMap.put(el, result);
            }
            return result;
        }

        public void resetData() {
            this.callMap.clear();
            this.locationRoots.clear();
        }

        private synchronized void processCall(CallMarker marker) {
            StackTraceElement[] stacktrace = marker.getStackTrace();
            if (stacktrace.length < 3) {
                return;
            }
            StackTraceElement root = stacktrace[2];
            this.locationRoots.put((Object)marker.location, (Object)root);
            CallCounter counter = this.getCounter(root);
            for (int i = 3; i < stacktrace.length; ++i) {
                StackTraceElement el = stacktrace[i];
                counter.addCaller(el);
                counter = this.getCounter(el);
            }
        }

        public synchronized void visitData(int locationId, GraphSerializer serializer, GraphVisitor visitor) {
            Collection roots = this.locationRoots.get((Object)locationId);
            serializer.serialize(roots, this.callMap, visitor);
        }

        @Override
        public void run() {
            try {
                CallMarker marker;
                while ((marker = CALLS.take()) != null) {
                    try {
                        this.processCall(marker);
                    }
                    catch (Exception e) {
                        Log.warn(e, "Failed to process call", new Object[0]);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

