/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import openmods.whodunit.Log;
import openmods.whodunit.Setup;
import openmods.whodunit.data.CallCollector;
import openmods.whodunit.data.LocationManager;
import openmods.whodunit.data.graph.GraphVisitor;
import openmods.whodunit.data.graph.GraphvizVisitor;
import openmods.whodunit.data.graph.JsonVisitor;
import openmods.whodunit.utils.CommandSyntaxException;

public class CommandDump
implements ICommand {
    private static final String COMMAND_NAME = "call_tracking";
    private static final String COMMAND_DUMP = "dump";
    private static final String COMMAND_RESET = "reset";
    private final Map<String, GraphVisitorFactory> outputs = Maps.newHashMap();
    private final List<String> subCommands;
    private final LocationManager locations;
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public CommandDump(LocationManager locations) {
        this.outputs.put("graphviz", new GraphVisitorFactory(){

            @Override
            public String getExtension() {
                return "gv";
            }

            @Override
            public GraphVisitor create(File file) {
                return new GraphvizVisitor(file);
            }
        });
        this.outputs.put("compact-json", new GraphVisitorFactory(){

            @Override
            public String getExtension() {
                return "json";
            }

            @Override
            public GraphVisitor create(File file) {
                return new JsonVisitor(file, false);
            }
        });
        this.outputs.put("pretty-json", new GraphVisitorFactory(){

            @Override
            public String getExtension() {
                return "json";
            }

            @Override
            public GraphVisitor create(File file) {
                return new JsonVisitor(file, true);
            }
        });
        this.subCommands = ImmutableList.of((Object)COMMAND_RESET, (Object)COMMAND_DUMP);
        this.locations = locations;
    }

    public int compareTo(Object o) {
        return COMMAND_NAME.compareTo(((ICommand)o).func_71517_b());
    }

    public String func_71517_b() {
        return COMMAND_NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        return "call_tracking dump <location> <format> OR\ncall_tracking reset";
    }

    public List func_71514_a() {
        return null;
    }

    private static File createFile(File dumpFolder, String location, String extension) {
        String filename;
        File result;
        String date = FORMATTER.format(new Date());
        int counter = 0;
        while ((result = new File(dumpFolder, filename = String.format("%s-%s-%d.%s", location, date, counter++, extension))).exists()) {
        }
        return result;
    }

    public void func_71515_b(ICommandSender sender, String[] command) {
        GraphVisitorFactory formatFactory;
        if (command.length < 1) {
            throw new CommandSyntaxException();
        }
        String subCommand = command[0];
        if (COMMAND_RESET.equalsIgnoreCase(subCommand)) {
            CallCollector.resetData();
            return;
        }
        if (command.length < 2) {
            throw new CommandSyntaxException();
        }
        String location = command[1];
        Integer locationId = this.locations.getIdForLocation(location);
        if (locationId == null) {
            throw new CommandSyntaxException();
        }
        if (COMMAND_DUMP.equalsIgnoreCase(subCommand)) {
            if (command.length != 3) {
                throw new CommandSyntaxException();
            }
            if (Setup.mcLocation == null) {
                return;
            }
            String format = command[2];
            formatFactory = this.outputs.get(format);
            if (formatFactory == null) {
                throw new CommandSyntaxException();
            }
        } else {
            throw new CommandNotFoundException();
        }
        File outputFolder = Setup.getDumpDir();
        File outputFile = CommandDump.createFile(outputFolder, location, formatFactory.getExtension());
        GraphVisitor visitor = formatFactory.create(outputFile);
        CallCollector.visitData(visitor, (Set<Integer>)ImmutableSet.of((Object)locationId));
        Log.info("Stored data to file %s", outputFile);
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender.func_70003_b(4, COMMAND_NAME);
    }

    public List func_71516_a(ICommandSender sender, String[] command) {
        if (command.length == 0) {
            return null;
        }
        if (command.length == 1) {
            return CommandDump.filterPrefixes(command[0], this.subCommands);
        }
        if (command.length == 2) {
            return CommandDump.filterPrefixes(command[1], this.locations.listLocationNames());
        }
        String subCommand = command[0];
        if (COMMAND_DUMP.equals(subCommand)) {
            return CommandDump.filterPrefixes(command[2], this.outputs.keySet());
        }
        return null;
    }

    public boolean func_82358_a(String[] command, int index) {
        return false;
    }

    public static List<String> filterPrefixes(String prefix, Collection<String> proposals) {
        prefix = prefix.toLowerCase();
        ArrayList result = Lists.newArrayList();
        for (String s : proposals) {
            if (!s.startsWith(prefix)) continue;
            result.add(s);
        }
        return result;
    }

    private static interface GraphVisitorFactory {
        public GraphVisitor create(File var1);

        public String getExtension();
    }
}

