/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.data.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import openmods.whodunit.data.CallCounter;
import openmods.whodunit.data.graph.GraphVisitor;

public class GraphSerializer {
    private int counter;
    private final Map<StackTraceElement, Integer> vertices = Maps.newHashMap();
    private final Set<StackTraceElement> alreadyVisited = Sets.newHashSet();

    private int getIdForVertex(StackTraceElement el) {
        Integer result = this.vertices.get(el);
        if (result == null) {
            result = this.counter++;
            this.vertices.put(el, result);
        }
        return result;
    }

    public void serialize(Collection<StackTraceElement> roots, Map<StackTraceElement, CallCounter> data, GraphVisitor visitor) {
        StackTraceElement callee;
        LinkedList todo = Lists.newLinkedList(roots);
        while ((callee = (StackTraceElement)todo.poll()) != null) {
            if (this.alreadyVisited.contains(callee)) continue;
            this.alreadyVisited.add(callee);
            CallCounter counter = data.get(callee);
            int calleeId = this.getIdForVertex(callee);
            visitor.visitVertex(calleeId, callee);
            for (Multiset.Entry callerCount : counter.callers.entrySet()) {
                StackTraceElement caller = (StackTraceElement)callerCount.getElement();
                todo.add(caller);
                int callerId = this.getIdForVertex(caller);
                visitor.visitEdge(calleeId, callerId, callerCount.getCount());
            }
        }
    }
}

