/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.data.graph;

import java.io.File;
import openmods.whodunit.data.graph.PrintWriterVisitor;

public class GraphvizVisitor
extends PrintWriterVisitor {
    private static final String PREAMBLE = "digraph G {\ngraph [\nrankdir = \"BT\"];\nnode [\nshape = \"rectangle\"\n];\n\n";

    public GraphvizVisitor(File outputFile) {
        super(outputFile);
        this.output.print(PREAMBLE);
    }

    @Override
    public void visitVertex(int index, StackTraceElement value) {
        this.output.format("node_%d [label = \"%s\"];\n", index, value.toString());
    }

    @Override
    public void visitEdge(int from, int to, int weight) {
        this.output.format("node_%s -> node_%d [label = \"%d\"];\n", to, from, weight);
    }

    @Override
    public void finish() {
        this.output.println("}");
        super.finish();
    }
}

