/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.data.graph;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import openmods.whodunit.data.graph.PrintWriterVisitor;

public class JsonVisitor
extends PrintWriterVisitor {
    private final JsonObject vertices = new JsonObject();
    private final JsonArray edges = new JsonArray();
    private final Gson gson;

    public JsonVisitor(File outputFile, boolean prettyPrint) {
        super(outputFile);
        GsonBuilder builder = new GsonBuilder();
        if (prettyPrint) {
            builder.setPrettyPrinting();
        }
        this.gson = builder.create();
    }

    @Override
    public void visitVertex(int index, StackTraceElement value) {
        JsonObject vertex = this.gson.toJsonTree((Object)value).getAsJsonObject();
        this.vertices.add(Integer.toString(index), (JsonElement)vertex);
    }

    @Override
    public void visitEdge(int from, int to, int weight) {
        JsonObject edge = new JsonObject();
        edge.addProperty("from", (Number)from);
        edge.addProperty("to", (Number)to);
        edge.addProperty("weigth", (Number)weight);
        this.edges.add((JsonElement)edge);
    }

    @Override
    public void finish() {
        JsonObject doc = new JsonObject();
        doc.add("vertices", (JsonElement)this.vertices);
        doc.add("edges", (JsonElement)this.edges);
        this.gson.toJson((JsonElement)doc, (Appendable)this.output);
        super.finish();
    }
}

