/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.data.graph;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import openmods.whodunit.data.graph.GraphVisitor;

public abstract class PrintWriterVisitor
implements GraphVisitor {
    protected final PrintWriter output;

    public PrintWriterVisitor(File outputFile) {
        try {
            Closer closer = Closer.create();
            try {
                OutputStream os = (OutputStream)closer.register((Closeable)new FileOutputStream(outputFile));
                Writer w = (Writer)closer.register((Closeable)new OutputStreamWriter(os, Charsets.UTF_8));
                this.output = (PrintWriter)closer.register((Closeable)new PrintWriter(w));
            }
            catch (Exception e) {
                closer.close();
                throw e;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void finish() {
        this.output.close();
    }
}

