/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.injection;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import openmods.whodunit.Log;
import openmods.whodunit.injection.MethodInjector;
import openmods.whodunit.injection.MethodMatcher;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassInjector
extends ClassVisitor {
    private final Collection<MethodMatcher> matchers;
    private final String rawClsName;

    public ClassInjector(ClassVisitor cv, String rawClsName, Collection<MethodMatcher> matchers) {
        super(262144, cv);
        this.matchers = ImmutableList.copyOf(matchers);
        this.rawClsName = rawClsName;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        for (MethodMatcher matcher : this.matchers) {
            if (!matcher.match(name, desc)) continue;
            Log.info("Injecting logger for location %d in method %s.%s(%s)", matcher.location, this.rawClsName, name, desc);
            return new MethodInjector(parent, matcher.location);
        }
        return parent;
    }

    public void visitEnd() {
        super.visitEnd();
        for (MethodMatcher matcher : this.matchers) {
            if (matcher.hasMatched()) continue;
            Log.warn("Matcher %s has not matched, not capturing part of calls", matcher);
        }
    }
}

