/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.injection;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.util.Collection;
import openmods.whodunit.config.MethodDescriptor;
import openmods.whodunit.data.LocationManager;
import openmods.whodunit.injection.MethodMatcher;
import openmods.whodunit.utils.VisitorHelper;
import org.objectweb.asm.Type;

public class MatcherMap {
    private final LocationManager locationManager;
    private final Multimap<String, MethodMatcher> matchers = HashMultimap.create();

    public MatcherMap(LocationManager locationManager) {
        this.locationManager = locationManager;
    }

    public String getClassName(String name) {
        name = name.replace('.', '/');
        return VisitorHelper.useSrgNames() ? FMLDeobfuscatingRemapper.INSTANCE.unmap(name) : name;
    }

    public void markMethodForInjection(String deobfCls, String description, String mcpName, String srgName, int location) {
        String obfCls = this.getClassName(deobfCls);
        this.matchers.put((Object)deobfCls, (Object)new MethodMatcher(obfCls, description, mcpName, srgName, location));
    }

    public void createFromDescription(String name, MethodDescriptor descriptor) {
        Preconditions.checkNotNull((Object)descriptor.cls, (String)"Class not set for method %s", (Object[])new Object[]{name});
        Preconditions.checkNotNull((Object)descriptor.returnType, (String)"Return type not set for method %s", (Object[])new Object[]{name});
        Preconditions.checkNotNull((Object)descriptor.mcpName, (String)"MCP name not set for method %s", (Object[])new Object[]{name});
        Preconditions.checkNotNull((Object)descriptor.srgName, (String)"SRG name not set for method %s", (Object[])new Object[]{name});
        Preconditions.checkNotNull((Object)descriptor.argTypes, (String)"Arguments not set for method %s", (Object[])new Object[]{name});
        int location = this.locationManager.getOrCreateIdForLocation(name);
        String[] argNames = descriptor.argTypes;
        Type[] argumentTypes = new Type[argNames.length];
        for (int i = 0; i < argNames.length; ++i) {
            String typeDescriptor = argNames[i];
            argumentTypes[i] = this.convertToType(typeDescriptor);
        }
        Type returnType = this.convertToType(descriptor.returnType);
        Type desc = Type.getMethodType((Type)returnType, (Type[])argumentTypes);
        this.markMethodForInjection(descriptor.cls, desc.getDescriptor(), descriptor.mcpName, descriptor.srgName, location);
    }

    protected Type convertToType(String typeDescriptor) {
        Type tmp = Type.getType((String)typeDescriptor);
        if (tmp.getSort() == 10) {
            String originalCls = tmp.getInternalName();
            String actualName = this.getClassName(originalCls);
            tmp = Type.getObjectType((String)actualName);
        }
        return tmp;
    }

    public Collection<MethodMatcher> getMatchers(String className) {
        return this.matchers.get((Object)className);
    }
}

