/*
 * Decompiled with CFR 0.152.
 */
package openmods.whodunit.injection;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import openmods.whodunit.utils.VisitorHelper;

public class MethodMatcher {
    private final String clsName;
    private final String description;
    private final String srgName;
    private final String mcpName;
    public final int location;
    private boolean hasMatched;

    public MethodMatcher(String clsName, String description, String mcpName, String srgName, int location) {
        this.clsName = clsName;
        this.description = description;
        this.srgName = srgName;
        this.mcpName = mcpName;
        this.location = location;
    }

    private boolean tryMatch(String methodName, String methodDesc) {
        if (!methodDesc.equals(this.description)) {
            return false;
        }
        if (methodName.equals(this.mcpName)) {
            return true;
        }
        if (!VisitorHelper.useSrgNames()) {
            return false;
        }
        String mapped = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.clsName, methodName, methodDesc);
        return mapped.equals(this.srgName);
    }

    public boolean match(String methodName, String methodDesc) {
        if (this.tryMatch(methodName, methodDesc)) {
            this.hasMatched = true;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s.[%s;%s] %s", this.clsName, this.mcpName, this.srgName, this.description);
    }

    public boolean hasMatched() {
        return this.hasMatched;
    }
}

